/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.evrete.api.FactBuilder;
import org.evrete.api.NamedType;
import org.evrete.api.RhsContext;
import org.evrete.api.RuntimeContext;
import org.evrete.api.Type;
import org.evrete.api.ValuesPredicate;
import org.evrete.api.builders.LhsBuilder;
import org.evrete.runtime.AbstractLhsFact;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.DefaultConditionManager;
import org.evrete.runtime.DefaultNamedTypeResolver;
import org.evrete.runtime.DefaultRuleBuilder;
import org.evrete.runtime.DefaultRuleSetBuilder;

class DefaultLhsBuilder<C extends RuntimeContext<C>>
extends DefaultNamedTypeResolver<Fact>
implements LhsBuilder<C> {
    private final DefaultRuleBuilder<C> ruleBuilder;
    private final AbstractRuntime<?, C> runtime;
    private final DefaultConditionManager conditionManager;

    DefaultLhsBuilder(DefaultRuleBuilder<C> ruleBuilder) {
        this.ruleBuilder = ruleBuilder;
        this.runtime = ruleBuilder.runtime();
        this.conditionManager = new DefaultConditionManager(ruleBuilder.runtime(), this);
    }

    DefaultConditionManager getConditionManager() {
        return this.conditionManager;
    }

    @Override
    public synchronized Fact addFactDeclaration(String name, Type<?> type) {
        Fact newFact = new Fact(super.size(), name, type);
        super.save(newFact);
        return newFact;
    }

    @Override
    public NamedType addFactDeclaration(String name, Class<?> type) {
        Type<?> t = this.runtime.getTypeResolver().getOrDeclare(type);
        return this.addFactDeclaration(name, (Type)t);
    }

    @Override
    public NamedType addFactDeclaration(String name, String type) {
        return this.addFactDeclaration(name, this.runtime.getTypeResolver().getOrDeclare(type));
    }

    @Override
    public DefaultLhsBuilder<C> where(String expression, double complexity) {
        this.whereInner(expression, complexity);
        return this;
    }

    @Override
    public DefaultLhsBuilder<C> where(ValuesPredicate predicate, double complexity, String ... references) {
        this.whereInner(predicate, complexity, references);
        return this;
    }

    @Override
    public DefaultLhsBuilder<C> where(Predicate<Object[]> predicate, double complexity, String ... references) {
        this.whereInner(predicate, complexity, references);
        return this;
    }

    @Override
    public DefaultRuleSetBuilder<C> execute() {
        return this.ruleBuilder.execute();
    }

    @Override
    public DefaultRuleSetBuilder<C> execute(Consumer<RhsContext> consumer) {
        return this.ruleBuilder.execute((Consumer)consumer);
    }

    @Override
    public DefaultRuleSetBuilder<C> execute(String literalRhs) {
        return this.ruleBuilder.execute(literalRhs);
    }

    DefaultLhsBuilder<C> buildLhs(Collection<FactBuilder> facts) {
        if (facts == null || facts.isEmpty()) {
            return this;
        }
        for (FactBuilder f : facts) {
            Class<?> c = f.getResolvedType();
            if (c == null) {
                this.addFactDeclaration(f.getName(), f.getUnresolvedType());
                continue;
            }
            this.addFactDeclaration(f.getName(), c);
        }
        return this;
    }

    private void whereInner(String expression, double complexity) {
        this.conditionManager.addLhsBuilderCondition(expression, complexity);
    }

    private void whereInner(ValuesPredicate predicate, double complexity, String[] references) {
        this.conditionManager.addLhsBuilderCondition(predicate, complexity, references);
    }

    private void whereInner(Predicate<Object[]> predicate, double complexity, String[] references) {
        this.conditionManager.addLhsBuilderCondition(predicate, complexity, references);
    }

    static class Fact
    extends AbstractLhsFact
    implements NamedType {
        final Type<?> type;

        public Fact(int inRuleIndex, String varName, Type<?> type) {
            super(inRuleIndex, varName);
            this.type = type;
        }

        @Override
        public Type<?> getType() {
            return this.type;
        }
    }
}

