/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import org.evrete.api.NamedType;

class DefaultNamedTypeResolver<T extends NamedType>
implements NamedType.Resolver {
    private final LinkedHashMap<String, T> map = new LinkedHashMap();

    DefaultNamedTypeResolver() {
    }

    public T resolve(String var) {
        NamedType t = (NamedType)this.map.get(var);
        if (t == null) {
            throw new NoSuchElementException("No type registered with variable '" + var + "'");
        }
        return (T)t;
    }

    protected int size() {
        return this.map.size();
    }

    public void save(T value) {
        NamedType prev = (NamedType)this.map.put(value.getVarName(), value);
        if (prev != null) {
            throw new IllegalArgumentException("Duplicate type reference '" + value.getVarName() + "'");
        }
    }

    Collection<T> rawValues() {
        return this.map.values();
    }

    @Override
    public final Collection<NamedType> getDeclaredFactTypes() {
        return Collections.unmodifiableCollection(this.rawValues());
    }
}

