/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Arrays;
import java.util.Collection;
import java.util.StringJoiner;
import org.evrete.runtime.AbstractLhsFact;
import org.evrete.runtime.ActiveType;
import org.evrete.runtime.AlphaAddress;

public class FactType
extends AbstractLhsFact {
    public static final FactType[] EMPTY_ARRAY = new FactType[0];
    private final ActiveType activeType;
    private final AlphaAddress alphaAddress;

    FactType(AbstractLhsFact other, ActiveType activeType, AlphaAddress alphaAddress) {
        super(other);
        this.activeType = activeType;
        this.alphaAddress = alphaAddress;
    }

    public ActiveType.Idx typeId() {
        return this.activeType.getId();
    }

    public ActiveType type() {
        return this.activeType;
    }

    public FactType(FactType other) {
        super(other);
        this.activeType = other.activeType;
        this.alphaAddress = other.alphaAddress;
    }

    public AlphaAddress getAlphaAddress() {
        return this.alphaAddress;
    }

    public static <T extends FactType> String toSimpleDebugString(T[] types) {
        return FactType.toSimpleDebugString(Arrays.asList(types));
    }

    public static <T extends FactType> String toSimpleDebugString(Collection<T> types) {
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        for (FactType type : types) {
            joiner.add("'" + type.getVarName() + "'");
        }
        return joiner.toString();
    }

    public String toString() {
        return "{var='" + this.getVarName() + "', type=" + String.valueOf(this.activeType.getId()) + ", address=" + String.valueOf(this.alphaAddress) + "}";
    }
}

