/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.time.Instant;
import java.util.concurrent.Executor;
import org.evrete.api.Copyable;
import org.evrete.api.IntToValue;
import org.evrete.api.LhsCondition;
import org.evrete.api.LhsField;
import org.evrete.api.RuleSession;
import org.evrete.api.ValuesPredicate;
import org.evrete.api.events.ConditionEvaluationEvent;
import org.evrete.api.events.Events;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.evaluation.ConditionEvaluationEventImpl;
import org.evrete.runtime.evaluation.DefaultEvaluatorHandle;
import org.evrete.util.BroadcastingPublisher;
import org.evrete.util.Indexed;

public class StoredCondition
extends LhsCondition<ValuesPredicate, String, ActiveField>
implements Indexed,
Copyable<StoredCondition> {
    private final DefaultEvaluatorHandle handle;
    private BroadcastingPublisher<ConditionEvaluationEvent> publisher;

    public StoredCondition(int index, ValuesPredicate predicate, double complexity, LhsField.Array<String, ActiveField> fields) {
        super(predicate, fields);
        this.handle = new DefaultEvaluatorHandle(index, complexity);
    }

    public StoredCondition(StoredCondition other) {
        super((ValuesPredicate)other.getCondition(), other.getDescriptor());
        this.handle = other.handle;
        this.publisher = other.publisher;
    }

    public DefaultEvaluatorHandle getHandle() {
        return this.handle;
    }

    public synchronized void setPredicate(ValuesPredicate predicate) {
        this.setCondition(predicate);
    }

    public synchronized Events.Publisher<ConditionEvaluationEvent> getCreatePublisher(Executor executor) {
        if (this.publisher == null) {
            this.publisher = new BroadcastingPublisher(executor);
        }
        return this.publisher;
    }

    public boolean test(RuleSession<?> context, IntToValue values) {
        if (this.publisher == null) {
            return ((ValuesPredicate)this.getCondition()).test(values);
        }
        Instant start = Instant.now();
        boolean b = ((ValuesPredicate)this.getCondition()).test(values);
        Instant end = Instant.now();
        Object[] arguments = new Object[this.getDescriptor().length()];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = values.get(i);
        }
        this.publisher.broadcast(new ConditionEvaluationEventImpl(context, start, end, b, (ValuesPredicate)this.getCondition(), arguments));
        return b;
    }

    @Override
    public StoredCondition copyOf() {
        return new StoredCondition(this);
    }

    @Override
    public int getIndex() {
        return this.handle.getIndex();
    }
}

