/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.rete;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import org.evrete.api.ReteMemory;
import org.evrete.api.spi.MemoryScope;
import org.evrete.runtime.PreHashed;
import org.evrete.runtime.rete.HashedCollection;

public class ConditionMemory
implements ReteMemory<MemoryEntry> {
    private final HashedCollection main = new HashedCollection();
    private final HashedCollection delta = new HashedCollection();

    void deleteAll(Predicate<MemoryEntry> predicate) {
        this.main.delete(predicate);
        this.delta.delete(predicate);
    }

    void saveNewEntry(MemoryScope destination, MemoryEntry entry) {
        if (destination == MemoryScope.DELTA) {
            this.delta.add(entry);
        } else if (destination == MemoryScope.MAIN) {
            this.main.add(entry);
        } else {
            throw new IllegalArgumentException("Unknown scope: " + String.valueOf((Object)destination));
        }
    }

    public int size(MemoryScope scope) {
        if (scope == MemoryScope.DELTA) {
            return this.delta.size();
        }
        if (scope == MemoryScope.MAIN) {
            return this.main.size();
        }
        throw new IllegalArgumentException("Unknown scope: " + String.valueOf((Object)scope));
    }

    @Override
    public void commit() {
        Iterator<MemoryEntry> iterator = this.delta.iterator();
        while (iterator.hasNext()) {
            MemoryEntry entry = iterator.next();
            this.main.add(entry.toMainScope());
            iterator.remove();
        }
    }

    @Override
    public void clear() {
        this.main.reset();
        this.delta.reset();
    }

    void clearDeltaMemory() {
        this.delta.reset();
    }

    public String toString() {
        return "{main=" + this.main.size() + ", delta=" + this.delta.size() + "}";
    }

    @Override
    public Iterator<MemoryEntry> iterator(MemoryScope scope) {
        switch (scope) {
            case DELTA: {
                return this.delta.iterator();
            }
            case MAIN: {
                return this.main.iterator();
            }
        }
        throw new IllegalStateException("Unknown scope " + String.valueOf((Object)scope));
    }

    public static final class MemoryEntry
    extends PreHashed {
        private final ScopedValueId[] scopedValueIds;

        public MemoryEntry(ScopedValueId[] scopedValueIds) {
            super(MemoryEntry.hashOf(scopedValueIds));
            this.scopedValueIds = scopedValueIds;
        }

        private MemoryEntry(ScopedValueId single) {
            this(new ScopedValueId[]{single});
        }

        private static int hashOf(ScopedValueId[] scopedValueIds) {
            int hash = 0;
            for (ScopedValueId single : scopedValueIds) {
                hash += hash * 31 + single.hashCode();
            }
            return hash;
        }

        ScopedValueId[] scopedValues() {
            return this.scopedValueIds;
        }

        MemoryEntry toMainScope() {
            ScopedValueId[] newKeys = new ScopedValueId[this.scopedValueIds.length];
            for (int i = 0; i < this.scopedValueIds.length; ++i) {
                newKeys[i] = this.scopedValueIds[i].toScope(MemoryScope.MAIN);
            }
            return new MemoryEntry(newKeys);
        }

        static MemoryEntry fromEntryNode(long values, MemoryScope scope) {
            return new MemoryEntry(new ScopedValueId(values, scope));
        }

        public ScopedValueId[] getScopedValueIds() {
            return this.scopedValueIds;
        }
    }

    public static class DeletePredicate
    implements Predicate<MemoryEntry> {
        private final int index;
        private final Set<Long> valuesToDelete;

        DeletePredicate(int index, Set<Long> valuesToDelete) {
            this.index = index;
            this.valuesToDelete = valuesToDelete;
        }

        @Override
        public boolean test(MemoryEntry memoryEntry) {
            ScopedValueId v = memoryEntry.getScopedValueIds()[this.index];
            return this.valuesToDelete.contains(v.getValueId());
        }

        public static Predicate<MemoryEntry> ofMultipleOR(Collection<DeletePredicate> predicates) {
            Iterator<DeletePredicate> iterator = predicates.iterator();
            if (iterator.hasNext()) {
                Predicate predicate = iterator.next();
                while (iterator.hasNext()) {
                    predicate = predicate.or(iterator.next());
                }
                return predicate;
            }
            return memoryEntry -> false;
        }
    }

    public static class ScopedValueId {
        private final long valueId;
        private final byte scope;

        public ScopedValueId(long valueId, MemoryScope scope) {
            this(valueId, ScopedValueId.toByte(scope));
        }

        private ScopedValueId(long valueId, byte scope) {
            this.valueId = valueId;
            this.scope = scope;
        }

        public MemoryScope getScope() {
            return ScopedValueId.fromByte(this.scope);
        }

        public ScopedValueId toScope(MemoryScope scope) {
            byte b = ScopedValueId.toByte(scope);
            if (this.scope == b) {
                return this;
            }
            return new ScopedValueId(this.valueId, b);
        }

        public long getValueId() {
            return this.valueId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScopedValueId that = (ScopedValueId)o;
            return this.valueId == that.valueId && this.scope == that.scope;
        }

        public int hashCode() {
            return (int)this.valueId;
        }

        static byte toByte(MemoryScope scope) {
            return (byte)(scope != MemoryScope.MAIN ? 1 : 0);
        }

        static MemoryScope fromByte(byte b) {
            return b == 0 ? MemoryScope.MAIN : MemoryScope.DELTA;
        }
    }
}

