/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal.compiler;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import javax.tools.JavaFileObject;
import org.evrete.spi.minimal.compiler.ClassPathJavaObject;

class ClassLoaderWrapper
extends ClassLoader {
    private final Map<String, byte[]> classDefinitions = new HashMap<String, byte[]>();
    private final Map<String, Collection<JavaFileObject>> fileObjects = new HashMap<String, Collection<JavaFileObject>>();

    ClassLoaderWrapper(ClassLoader parent) {
        super(parent);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        int pos = name.lastIndexOf(".class");
        if (pos < 0) {
            return super.getResourceAsStream(name);
        }
        String noExtension = name.substring(0, pos);
        String binaryName = noExtension.replaceAll("/", ".");
        byte[] bytes = this.classDefinitions.get(binaryName);
        if (bytes == null) {
            return super.getResourceAsStream(name);
        }
        return new ByteArrayInputStream(bytes);
    }

    Collection<JavaFileObject> getDefinedClasses(String packageName) {
        LinkedList<JavaFileObject> result = new LinkedList<JavaFileObject>();
        this.walk(classLoaderWrapper -> result.addAll(classLoaderWrapper.getLocallyDefinedClasses(packageName)));
        return result;
    }

    void walk(Consumer<ClassLoaderWrapper> consumer) {
        consumer.accept(this);
        for (ClassLoader current = this.getParent(); current != null; current = current.getParent()) {
            if (!(current instanceof ClassLoaderWrapper)) continue;
            consumer.accept((ClassLoaderWrapper)current);
        }
    }

    Collection<JavaFileObject> getLocallyDefinedClasses(String packageName) {
        return this.fileObjects.getOrDefault(packageName, Collections.emptyList());
    }

    void defineNewClass(String binaryName, byte[] classBytes) {
        String packageName = this.packageNameOf(binaryName);
        Class<?> defined = super.defineClass(binaryName, classBytes, 0, classBytes.length);
        this.classDefinitions.put(binaryName, classBytes);
        this.fileObjects.computeIfAbsent(packageName, k -> new ArrayList()).add(new ClassPathJavaObject(defined, classBytes));
    }

    private String packageNameOf(String className) {
        int lastDot = className.lastIndexOf(46);
        return lastDot == -1 ? null : className.substring(0, lastDot);
    }
}

