/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.evrete.util.CommonUtils;

public class CombinationIterator<T>
implements Iterator<T[]> {
    private static final int END = -1;
    private final IntFunction<Iterator<T>> iteratorFunction;
    private final T[] combination;
    private final Iterator<T>[] iterators;
    private int readNextPosition;
    private final int size;

    public <S> CombinationIterator(Class<T> type, S[] sources, Function<S, Iterator<T>> iteratorFunction) {
        this(sources, CommonUtils.array(type, sources.length), iteratorFunction);
    }

    public <S> CombinationIterator(S[] sources, T[] sharedResultArray, Function<S, Iterator<T>> iteratorFunction) {
        this(sharedResultArray, index -> (Iterator)iteratorFunction.apply(sources[index]));
    }

    public CombinationIterator(T[] sharedResultArray, IntFunction<Iterator<T>> iteratorFunction) {
        this.size = sharedResultArray.length;
        this.iteratorFunction = iteratorFunction;
        this.combination = sharedResultArray;
        this.iterators = new Iterator[this.size];
        this.initializeIterators();
    }

    private void initializeIterators() {
        for (int i = 0; i < this.size; ++i) {
            this.iterators[i] = this.iteratorFunction.apply(i);
            if (this.iterators[i].hasNext()) continue;
            this.readNextPosition = -1;
            return;
        }
        this.readNextPosition = 0;
    }

    @Override
    public boolean hasNext() {
        return this.readNextPosition != -1;
    }

    protected T advanceIterator(int index) {
        return this.iterators[index].next();
    }

    @Override
    public T[] next() {
        if (this.hasNext()) {
            for (int i = this.size - 1; i >= this.readNextPosition; --i) {
                this.combination[i] = this.advanceIterator(i);
            }
            this.readNextPosition = this.computeNextPosition();
            return this.combination;
        }
        throw new NoSuchElementException();
    }

    private int computeNextPosition() {
        int ret = -1;
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.iterators[i].hasNext()) {
                return i;
            }
            if (i > 0) {
                this.iterators[i] = this.iteratorFunction.apply(i);
                ret = i;
                continue;
            }
            ret = -1;
        }
        return ret;
    }
}

