/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class FilteringIterator<T>
implements Iterator<T> {
    private final Iterator<T> iterator;
    private final Predicate<T> predicate;
    private T nextElement;
    private boolean nextElementSet = false;

    public FilteringIterator(Iterator<T> iterator, Predicate<T> predicate) {
        this.iterator = iterator;
        this.predicate = predicate;
    }

    @Override
    public boolean hasNext() {
        if (this.nextElementSet) {
            return true;
        }
        return this.setNextElement();
    }

    @Override
    public T next() {
        if (!this.nextElementSet && !this.setNextElement()) {
            throw new NoSuchElementException();
        }
        this.nextElementSet = false;
        return this.nextElement;
    }

    private boolean setNextElement() {
        while (this.iterator.hasNext()) {
            T element = this.iterator.next();
            if (!this.predicate.test(element)) continue;
            this.nextElement = element;
            this.nextElementSet = true;
            return true;
        }
        return false;
    }
}

