/*
 * Decompiled with CFR 0.152.
 */
package org.evrete;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import org.evrete.Configuration;
import org.evrete.api.Knowledge;
import org.evrete.api.OrderedServiceProvider;
import org.evrete.api.StatefulSession;
import org.evrete.api.StatelessSession;
import org.evrete.api.TypeResolver;
import org.evrete.api.spi.DSLKnowledgeProvider;
import org.evrete.api.spi.MemoryFactoryProvider;
import org.evrete.api.spi.SourceCompilerProvider;
import org.evrete.api.spi.TypeResolverProvider;
import org.evrete.runtime.AbstractKnowledgeService;
import org.evrete.runtime.KnowledgeRuntime;
import org.evrete.util.DelegatingExecutorService;

public class KnowledgeService
extends AbstractKnowledgeService {
    private final Configuration configuration;
    private final MemoryFactoryProvider collectionsServiceProvider;
    private final TypeResolverProvider typeResolverProvider;
    private final SourceCompilerProvider sourceCompilerProvider;
    private ClassLoader classLoader;

    public KnowledgeService(Configuration conf) {
        this(new Builder(conf));
    }

    private KnowledgeService(Builder builder) {
        super(KnowledgeService.executorFactory(builder));
        this.configuration = builder.conf;
        this.collectionsServiceProvider = builder.getMemoryFactoryProvider();
        this.typeResolverProvider = builder.getTypeResolverProvider();
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.sourceCompilerProvider = builder.getSourceCompilerProvider();
    }

    public KnowledgeService() {
        this(new Configuration());
    }

    static ExecutorService executorFactory(Builder builder) {
        if (builder.executor == null) {
            int parallelism = builder.conf.getAsInteger("evrete.core.parallelism", Runtime.getRuntime().availableProcessors());
            boolean daemonThreads = builder.conf.getAsBoolean("evrete.core.daemon-threads", true);
            return new DelegatingExecutorService(parallelism, daemonThreads);
        }
        return new DelegatingExecutorService(builder.executor);
    }

    public static Builder builder() {
        return new Builder(new Configuration());
    }

    public static Builder builder(Configuration configuration) {
        return new Builder(configuration);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void shutdown() {
        super.shutdownInner();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Knowledge newKnowledge() {
        return this.newKnowledge((String)null);
    }

    public Knowledge newKnowledge(String name) {
        return new KnowledgeRuntime(this, name);
    }

    @Deprecated
    public Knowledge newKnowledge(TypeResolver typeResolver) {
        return this.newKnowledge();
    }

    @Deprecated
    public Knowledge newKnowledge(TypeResolver typeResolver, String name) {
        return new KnowledgeRuntime(this, name);
    }

    @Deprecated
    public DSLKnowledgeProvider getDSL(String dsl) {
        return DSLKnowledgeProvider.load(dsl);
    }

    @Deprecated
    public DSLKnowledgeProvider getDSL(Class<? extends DSLKnowledgeProvider> dsl) {
        return DSLKnowledgeProvider.load(dsl);
    }

    @Deprecated
    public Knowledge newKnowledge(String dsl, URL ... resources) throws IOException {
        return this.deprecatedStub(dsl, (Object[])resources);
    }

    @Deprecated
    public Knowledge newKnowledge(Class<? extends DSLKnowledgeProvider> dsl, URL ... resources) throws IOException {
        return this.deprecatedStub(dsl, (Object[])resources);
    }

    @Deprecated
    public Knowledge newKnowledge(String dsl, File ... resources) throws IOException {
        return this.deprecatedStub(dsl, (Object[])resources);
    }

    @Deprecated
    public Knowledge newKnowledge(Class<? extends DSLKnowledgeProvider> dsl, File ... resources) throws IOException {
        return this.deprecatedStub(dsl, (Object[])resources);
    }

    @Deprecated
    public Knowledge newKnowledge(Class<? extends DSLKnowledgeProvider> dsl, TypeResolver resolver, File ... resources) throws IOException {
        return this.deprecatedStub(dsl, (Object[])resources);
    }

    @Deprecated
    public Knowledge newKnowledge(String dsl, TypeResolver resolver, File ... resources) throws IOException {
        return this.deprecatedStub(dsl, (Object[])resources);
    }

    @Deprecated
    public Knowledge newKnowledge(String dsl, TypeResolver typeResolver, URL ... resources) throws IOException {
        return this.deprecatedStub(dsl, (Object[])resources);
    }

    @Deprecated
    public Knowledge newKnowledge(Class<? extends DSLKnowledgeProvider> dsl, TypeResolver typeResolver, URL ... resources) throws IOException {
        return this.deprecatedStub(dsl, (Object[])resources);
    }

    @Deprecated
    public Knowledge newKnowledge(String dsl, Reader ... resources) throws IOException {
        return this.deprecatedStub(dsl, (Object[])resources);
    }

    @Deprecated
    public Knowledge newKnowledge(Class<? extends DSLKnowledgeProvider> dsl, Reader ... resources) throws IOException {
        return this.deprecatedStub(dsl, (Object[])resources);
    }

    @Deprecated
    public Knowledge newKnowledge(String dsl, TypeResolver typeResolver, Reader ... resources) throws IOException {
        return this.deprecatedStub(dsl, (Object[])resources);
    }

    @Deprecated
    public Knowledge newKnowledge(Class<? extends DSLKnowledgeProvider> dsl, TypeResolver typeResolver, Reader ... resources) throws IOException {
        return this.deprecatedStub(dsl, (Object[])resources);
    }

    @Deprecated
    public Knowledge newKnowledge(String dsl, InputStream ... resources) throws IOException {
        return this.deprecatedStub(dsl, (Object[])resources);
    }

    @Deprecated
    public Knowledge newKnowledge(Class<? extends DSLKnowledgeProvider> dsl, InputStream ... resources) throws IOException {
        return this.deprecatedStub(dsl, (Object[])resources);
    }

    @Deprecated
    public Knowledge newKnowledge(String dsl, TypeResolver typeResolver, InputStream ... resources) throws IOException {
        return this.deprecatedStub(dsl, (Object[])resources);
    }

    @Deprecated
    public Knowledge newKnowledge(Class<? extends DSLKnowledgeProvider> dsl, TypeResolver typeResolver, InputStream ... resources) throws IOException {
        return this.deprecatedStub(dsl, (Object[])resources);
    }

    @Deprecated
    public Knowledge newKnowledge(String dsl, Class<?> ... resources) throws IOException {
        return this.deprecatedStub(dsl, (Object[])resources);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public MemoryFactoryProvider getMemoryFactoryProvider() {
        return this.collectionsServiceProvider;
    }

    public SourceCompilerProvider getSourceCompilerProvider() {
        return this.sourceCompilerProvider;
    }

    public TypeResolverProvider getTypeResolverProvider() {
        return this.typeResolverProvider;
    }

    private Knowledge deprecatedStub(String provider, Object[] resources) throws IOException {
        Knowledge knowledge = this.newKnowledge();
        knowledge.importRules(provider, (Object)resources);
        return knowledge;
    }

    private Knowledge deprecatedStub(Class<? extends DSLKnowledgeProvider> type, Object[] resources) throws IOException {
        Knowledge knowledge = this.newKnowledge();
        DSLKnowledgeProvider provider = DSLKnowledgeProvider.load(type);
        knowledge.importRules(provider, (Object)resources);
        return knowledge;
    }

    @Deprecated
    public Knowledge newKnowledge(Class<? extends DSLKnowledgeProvider> dsl, Class<?> ... resources) throws IOException {
        return this.deprecatedStub(dsl, (Object[])resources);
    }

    @Deprecated
    public Knowledge newKnowledge(String dsl, TypeResolver typeResolver, Class<?> ... resources) throws IOException {
        return this.deprecatedStub(dsl, (Object[])resources);
    }

    @Deprecated
    public Knowledge newKnowledge(Class<? extends DSLKnowledgeProvider> dsl, TypeResolver typeResolver, Class<?> ... resources) throws IOException {
        return this.deprecatedStub(dsl, (Object[])resources);
    }

    public StatefulSession newStatefulSession() {
        return this.newKnowledge().newStatefulSession();
    }

    public StatelessSession newStatelessSession() {
        return this.newKnowledge().newStatelessSession();
    }

    @Deprecated
    public Knowledge newKnowledge(String dsl, String ... resources) throws IOException {
        return this.deprecatedStub(dsl, (Object[])resources);
    }

    @Deprecated
    public Knowledge newKnowledge(Class<? extends DSLKnowledgeProvider> dsl, String ... resources) throws IOException {
        return this.deprecatedStub(dsl, (Object[])resources);
    }

    public static class Builder {
        private final Configuration conf;
        private Class<? extends MemoryFactoryProvider> memoryFactoryProvider;
        private Class<? extends TypeResolverProvider> typeResolverProvider;
        private Class<? extends SourceCompilerProvider> sourceCompilerProvider;
        private ExecutorService executor;

        private Builder(Configuration conf) {
            this.conf = conf;
        }

        public Builder withMemoryFactoryProvider(Class<? extends MemoryFactoryProvider> memoryFactoryProvider) {
            this.memoryFactoryProvider = memoryFactoryProvider;
            return this;
        }

        public Builder withTypeResolverProvider(Class<? extends TypeResolverProvider> typeResolverProvider) {
            this.typeResolverProvider = typeResolverProvider;
            return this;
        }

        public Builder withSourceCompilerProvider(Class<? extends SourceCompilerProvider> sourceCompilerProvider) {
            this.sourceCompilerProvider = sourceCompilerProvider;
            return this;
        }

        public Builder withExecutor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public KnowledgeService build() {
            return new KnowledgeService(this);
        }

        private MemoryFactoryProvider getMemoryFactoryProvider() {
            return this.loadCoreSPI(MemoryFactoryProvider.class, "evrete.spi.memory-factory", this.memoryFactoryProvider);
        }

        private TypeResolverProvider getTypeResolverProvider() {
            return this.loadCoreSPI(TypeResolverProvider.class, "evrete.spi.type-resolver", this.typeResolverProvider);
        }

        private SourceCompilerProvider getSourceCompilerProvider() {
            return this.loadCoreSPI(SourceCompilerProvider.class, "evrete.spi.source-compiler", this.sourceCompilerProvider);
        }

        private <Z extends OrderedServiceProvider, I extends Z> Z loadCoreSPI(Class<Z> clazz, String propertyName, Class<I> implClass) {
            if (implClass != null) {
                try {
                    return (Z)((OrderedServiceProvider)implClass.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unable to instantiate implementation instance of " + String.valueOf(implClass), e);
                }
            }
            String className = this.conf.getProperty(propertyName);
            if (className != null) {
                try {
                    return (Z)((OrderedServiceProvider)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unable to instantiate implementation instance of " + className, e);
                }
            }
            LinkedList providers = new LinkedList();
            ServiceLoader.load(clazz).iterator().forEachRemaining(providers::add);
            Collections.sort(providers);
            if (providers.isEmpty()) {
                throw new IllegalStateException("Implementation missing: " + String.valueOf(clazz));
            }
            return (Z)((OrderedServiceProvider)providers.iterator().next());
        }
    }
}

