/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.api.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.LinkedList;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.StringJoiner;
import org.evrete.KnowledgeService;
import org.evrete.api.Knowledge;
import org.evrete.api.RuntimeContext;
import org.evrete.api.TypeResolver;

public interface DSLKnowledgeProvider {
    public String getName();

    default public <C extends RuntimeContext<C>> void appendTo(RuntimeContext<C> context, Object source) throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Deprecated
    default public Knowledge create(KnowledgeService service, URL ... resources) throws IOException {
        Knowledge knowledge = service.newKnowledge();
        for (URL resource : resources) {
            this.appendTo(knowledge, resource);
        }
        return knowledge;
    }

    @Deprecated
    default public Knowledge create(KnowledgeService service, TypeResolver typeResolver, URL ... resources) throws IOException {
        return this.create(service, resources);
    }

    @Deprecated
    default public Knowledge create(KnowledgeService service, InputStream ... streams) throws IOException {
        Knowledge knowledge = service.newKnowledge();
        for (InputStream stream : streams) {
            this.appendTo(knowledge, stream);
        }
        return knowledge;
    }

    @Deprecated
    default public Knowledge create(KnowledgeService service, TypeResolver resolver, File ... files) throws IOException {
        return this.create(service, files);
    }

    @Deprecated
    default public Knowledge create(KnowledgeService service, File ... files) throws IOException {
        URL[] urls = new URL[files.length];
        for (int i = 0; i < files.length; ++i) {
            urls[i] = files[i].toURI().toURL();
        }
        return this.create(service, urls);
    }

    @Deprecated
    default public Knowledge create(KnowledgeService service, TypeResolver typeResolver, InputStream ... streams) throws IOException {
        return this.create(service, streams);
    }

    @Deprecated
    default public Knowledge create(KnowledgeService service, Reader ... streams) throws IOException {
        Knowledge knowledge = service.newKnowledge();
        for (Reader stream : streams) {
            this.appendTo(knowledge, stream);
        }
        return knowledge;
    }

    @Deprecated
    default public Knowledge create(KnowledgeService service, TypeResolver typeResolver, Reader ... streams) throws IOException {
        return this.create(service, streams);
    }

    public static DSLKnowledgeProvider load(String dsl) {
        Objects.requireNonNull(dsl, "DSL identifier cannot be null");
        ServiceLoader<DSLKnowledgeProvider> loader = ServiceLoader.load(DSLKnowledgeProvider.class);
        LinkedList<DSLKnowledgeProvider> found = new LinkedList<DSLKnowledgeProvider>();
        StringJoiner knownProviders = new StringJoiner(", ", "[", "]");
        for (DSLKnowledgeProvider provider : loader) {
            String name = provider.getName();
            if (dsl.equals(name)) {
                found.add(provider);
            }
            knownProviders.add("'" + name + "' = " + provider.getClass().getName());
        }
        if (found.isEmpty()) {
            throw new IllegalStateException("DSL provider '" + dsl + "' is not found. Make sure the corresponding implementation is available on the classpath. Available providers: " + String.valueOf(knownProviders));
        }
        if (found.size() > 1) {
            throw new IllegalStateException("Multiple DSL providers found implementing the '" + dsl + "' language. Known providers: " + String.valueOf(knownProviders));
        }
        return (DSLKnowledgeProvider)found.iterator().next();
    }

    public static DSLKnowledgeProvider load(Class<? extends DSLKnowledgeProvider> dsl) {
        Objects.requireNonNull(dsl, "The DSL class must not be null.");
        try {
            return dsl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate DSL class instance: " + dsl.getName(), e);
        }
    }
}

