/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.collections;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.evrete.collections.ObjIntFunction;
import org.evrete.util.Indexed;

public class ForkingArray<V extends Indexed> {
    static final int DEFAULT_INITIAL_SIZE = 16;
    private Object[] array;
    private final ForkingArray<V> parent;
    private final int dataOffset;
    private int nextWriteIndex;
    private final int initialArraySize;

    private ForkingArray(int initialArraySize, ForkingArray<V> parent) {
        if (initialArraySize < 1) {
            throw new IllegalArgumentException("Initial array size must be greater than 0");
        }
        this.array = new Object[initialArraySize];
        this.initialArraySize = initialArraySize;
        this.nextWriteIndex = 0;
        this.parent = parent;
        this.dataOffset = parent == null ? 0 : parent.dataOffset + parent.nextWriteIndex;
    }

    public ForkingArray() {
        this(16);
    }

    public ForkingArray(int initialArraySize) {
        this(initialArraySize, null);
    }

    int getDataOffset() {
        return this.dataOffset;
    }

    int getInitialArraySize() {
        return this.initialArraySize;
    }

    public void forEach(Consumer<? super V> consumer) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            consumer.accept(this.get(i));
        }
    }

    public void update(UnaryOperator<V> op) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Indexed newVal = (Indexed)op.apply(this.get(i));
            this.set(i, newVal);
        }
    }

    public int size() {
        return this.nextWriteIndex + this.dataOffset;
    }

    public Stream<V> stream(boolean parallel) {
        Stream stream = this.stream();
        return parallel ? (Stream)stream.parallel() : stream;
    }

    public Stream<V> stream() {
        return IntStream.range(0, this.size()).mapToObj(this::get);
    }

    public ForkingArray<V> newBranch() {
        return new ForkingArray<V>(this.initialArraySize, this);
    }

    public synchronized <T> V append(T element, ObjIntFunction<T, V> mapper) {
        if (this.nextWriteIndex >= this.array.length) {
            this.array = Arrays.copyOf(this.array, this.array.length * 2);
        }
        Indexed ret = (Indexed)mapper.apply(this.nextWriteIndex + this.dataOffset, element);
        this.array[this.nextWriteIndex] = ret;
        ++this.nextWriteIndex;
        return (V)ret;
    }

    public V get(int index) {
        int adjustedIndex = index - this.dataOffset;
        if (adjustedIndex < 0) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.get(index);
        }
        if (adjustedIndex >= this.nextWriteIndex) {
            return null;
        }
        return (V)((Indexed)this.array[adjustedIndex]);
    }

    private void set(int index, V value) {
        int adjustedIndex = index - this.dataOffset;
        if (adjustedIndex < 0) {
            if (this.parent != null) {
                this.parent.set(index, value);
            }
        } else if (adjustedIndex < this.nextWriteIndex) {
            this.array[adjustedIndex] = value;
        }
    }
}

