/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.collections;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.evrete.collections.ForkingArray;
import org.evrete.util.ForkingMap;
import org.evrete.util.Indexed;
import org.evrete.util.MapEntryImpl;

public abstract class ForkingArrayMap<T, MatchKey, FastKey extends Indexed, Stored> {
    private final ForkingArray<IndexedMapEntry<FastKey, Stored>> array;
    private final ForkingMap<MatchKey, IndexedMapEntry<FastKey, Stored>> keyMap;
    private final Function<T, MatchKey> keyFunction;

    protected ForkingArrayMap(Function<T, MatchKey> keyFunction) {
        this.keyFunction = keyFunction;
        this.keyMap = new ForkingMap();
        this.array = new ForkingArray();
    }

    protected ForkingArrayMap(ForkingArrayMap<T, MatchKey, FastKey, Stored> other) {
        this.keyFunction = other.keyFunction;
        this.keyMap = other.keyMap.nextBranch();
        this.array = other.array.newBranch();
    }

    public Stream<Stored> values() {
        return this.array.stream().map(MapEntryImpl::getValue);
    }

    protected abstract FastKey generateKey(T var1, int var2);

    protected abstract Stored generateValue(FastKey var1, T var2);

    public void update(UnaryOperator<Stored> operator) {
        this.array.update(entry -> new IndexedMapEntry((Indexed)entry.getKey(), operator.apply(entry.getValue())));
    }

    public int size() {
        return this.array.size();
    }

    public void forEach(Consumer<Map.Entry<FastKey, Stored>> consumer) {
        this.array.forEach(consumer);
    }

    public void forEachValue(Consumer<Stored> consumer) {
        this.array.forEach((? super V entry) -> consumer.accept(entry.getValue()));
    }

    public synchronized Map.Entry<FastKey, Stored> getOrCreateEntry(T value) {
        MatchKey valueKey = this.keyFunction.apply(value);
        IndexedMapEntry found = this.keyMap.get(valueKey);
        if (found == null) {
            found = this.array.append(value, (i, v) -> {
                FastKey newKey = this.generateKey(value, i);
                Stored newValue = this.generateValue(newKey, value);
                return new IndexedMapEntry<FastKey, Stored>(newKey, newValue);
            });
            this.keyMap.put(valueKey, found);
        }
        return found;
    }

    public Stored get(FastKey key) {
        IndexedMapEntry<FastKey, Stored> entry = this.array.get(key.getIndex());
        return entry == null ? null : (Stored)entry.getValue();
    }

    private static class IndexedMapEntry<K extends Indexed, V>
    extends MapEntryImpl<K, V>
    implements Indexed {
        public IndexedMapEntry(K key, V value) {
            super(key, value);
        }

        @Override
        public int getIndex() {
            return ((Indexed)this.getKey()).getIndex();
        }
    }
}

