/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.collections;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.evrete.util.Indexed;
import org.evrete.util.MapEntryImpl;

public abstract class IndexingArrayMap<T, MatchKey, FastKey extends Indexed, Stored> {
    private static final int DEFAULT_INITIAL_SIZE = 16;
    private final HashMap<MatchKey, Integer> keyMap;
    private InnerMapEntry<FastKey, Stored>[] array;
    private final Function<T, MatchKey> keyFunction;
    private int nextWriteIndex;

    protected abstract FastKey generateKey(T var1, int var2);

    protected abstract Stored generateValue(FastKey var1, T var2);

    public IndexingArrayMap(Function<T, MatchKey> keyFunction) {
        this.keyMap = new HashMap();
        this.keyFunction = keyFunction;
        this.array = new InnerMapEntry[16];
    }

    protected IndexingArrayMap(IndexingArrayMap<T, MatchKey, FastKey, Stored> other) {
        this.keyMap = new HashMap<MatchKey, Integer>(other.keyMap);
        this.array = (InnerMapEntry[])other.array.clone();
        this.keyFunction = other.keyFunction;
        this.nextWriteIndex = other.nextWriteIndex;
    }

    protected IndexingArrayMap(IndexingArrayMap<T, MatchKey, FastKey, Stored> other, UnaryOperator<Stored> updateFunction) {
        this(other);
        for (int i = 0; i < this.nextWriteIndex; ++i) {
            Object v = this.array[i].getValue();
            this.array[i] = this.array[i].clone(updateFunction.apply(v));
        }
    }

    public int size() {
        return this.array.length;
    }

    public Stored get(FastKey key) {
        return (Stored)this.array[key.getIndex()].getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(Consumer<Stored> consumer) {
        HashMap<MatchKey, Integer> hashMap = this.keyMap;
        synchronized (hashMap) {
            for (int i = 0; i < this.nextWriteIndex; ++i) {
                InnerMapEntry<FastKey, Stored> entry = this.array[i];
                consumer.accept(entry.getValue());
            }
        }
    }

    public Stream<Stored> values() {
        return Arrays.stream(this.array).filter(Objects::nonNull).map(MapEntryImpl::getValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<FastKey, Stored> getOrCreateEntry(T arg) {
        HashMap<MatchKey, Integer> hashMap = this.keyMap;
        synchronized (hashMap) {
            MatchKey key = this.keyFunction.apply(arg);
            Integer index = this.keyMap.computeIfAbsent(key, k -> {
                this.ensureCapacity();
                int idx = this.nextWriteIndex++;
                FastKey fastKey = this.generateKey(arg, idx);
                Stored stored = this.generateValue(fastKey, arg);
                InnerMapEntry<FastKey, Stored> entry = new InnerMapEntry<FastKey, Stored>(fastKey, stored);
                this.array[idx] = entry;
                return idx;
            });
            return this.array[index];
        }
    }

    private void ensureCapacity() {
        if (this.nextWriteIndex >= this.array.length) {
            this.array = Arrays.copyOf(this.array, this.array.length * 2);
        }
    }

    public Stored get(int index) {
        if (index < 0 || index >= this.array.length) {
            throw new NoSuchElementException("No such index: " + index + " in index map " + this.getClass().getName());
        }
        return this.getUnchecked(index);
    }

    public Stored getUnchecked(int index) {
        return (Stored)this.array[index];
    }

    public String toString() {
        return Arrays.toString(this.array);
    }

    static class InnerMapEntry<FastKey extends Indexed, Stored>
    extends MapEntryImpl<FastKey, Stored> {
        InnerMapEntry(FastKey key, Stored value) {
            super(key, value);
        }

        private InnerMapEntry<FastKey, Stored> clone(Stored newValue) {
            return new InnerMapEntry<Indexed, Stored>((Indexed)this.getKey(), newValue);
        }
    }
}

