/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.evrete.api.Copyable;
import org.evrete.api.events.ContextEvent;
import org.evrete.api.events.EnvironmentChangeEvent;
import org.evrete.api.events.Events;
import org.evrete.api.events.KnowledgeCreatedEvent;
import org.evrete.api.events.SessionClosedEvent;
import org.evrete.api.events.SessionCreatedEvent;
import org.evrete.api.events.SessionFireEvent;
import org.evrete.util.BroadcastingPublisher;

public class EventMessageBus
implements Copyable<EventMessageBus> {
    private final Executor executor;
    private final Map<Class<? extends ContextEvent>, Handler<? extends ContextEvent>> handlers;

    public EventMessageBus(Executor executor) {
        this.executor = executor;
        this.handlers = new HashMap<Class<? extends ContextEvent>, Handler<? extends ContextEvent>>();
        this.register(KnowledgeCreatedEvent.class, new KnowledgeCreatedEventHandler(executor));
        this.register(SessionCreatedEvent.class, new SessionCreatedEventHandler(executor));
        this.register(SessionClosedEvent.class, new SessionClosedEventHandler(executor));
        this.register(SessionFireEvent.class, new SessionFireEventHandler(executor));
        this.register(EnvironmentChangeEvent.class, new EnvironmentChangeEventHandler(executor));
    }

    private EventMessageBus(EventMessageBus parent) {
        this.executor = parent.executor;
        HashMap<Class<? extends ContextEvent>, Handler<? extends ContextEvent>> copy = new HashMap<Class<? extends ContextEvent>, Handler<? extends ContextEvent>>();
        parent.handlers.forEach((aClass, handler) -> copy.put((Class<? extends ContextEvent>)aClass, (Handler)handler.copyOf()));
        this.handlers = copy;
    }

    private <E extends ContextEvent> void register(Class<E> type, Handler<E> handler) {
        this.handlers.put(type, handler);
    }

    Map<Class<? extends ContextEvent>, Handler<?>> getHandlers() {
        return this.handlers;
    }

    public <E extends ContextEvent> void broadcast(Class<E> type, E event) {
        this.getHandler(type).broadcast(event);
    }

    public <E extends ContextEvent> Events.Subscription subscribe(Class<E> eventClass, boolean async, Consumer<E> listener) {
        return this.getHandler(eventClass).subscribe(async, listener);
    }

    public <E extends ContextEvent> Events.Publisher<E> getPublisher(Class<E> eventClass) {
        return this.getHandler(eventClass);
    }

    private <E extends ContextEvent> Handler<E> getHandler(Class<E> eventClass) {
        Handler<? extends ContextEvent> handler = this.handlers.get(eventClass);
        if (handler == null) {
            throw new IllegalArgumentException("No broadcast publisher found for event type " + String.valueOf(eventClass));
        }
        return handler;
    }

    @Override
    public synchronized EventMessageBus copyOf() {
        return new EventMessageBus(this);
    }

    static class KnowledgeCreatedEventHandler
    extends Handler<KnowledgeCreatedEvent> {
        KnowledgeCreatedEventHandler(Executor executor) {
            super(executor);
        }

        KnowledgeCreatedEventHandler(Handler<KnowledgeCreatedEvent> other) {
            super(other);
        }

        @Override
        public Handler<KnowledgeCreatedEvent> copyOf() {
            return new KnowledgeCreatedEventHandler(this);
        }
    }

    static abstract class Handler<E extends ContextEvent>
    extends BroadcastingPublisher<E>
    implements Copyable<Handler<E>> {
        Handler(Executor executor) {
            super(executor);
        }

        protected Handler(Handler<E> other) {
            super(other);
        }
    }

    static class SessionCreatedEventHandler
    extends Handler<SessionCreatedEvent> {
        SessionCreatedEventHandler(Executor executor) {
            super(executor);
        }

        SessionCreatedEventHandler(SessionCreatedEventHandler other) {
            super(other);
        }

        @Override
        public Handler<SessionCreatedEvent> copyOf() {
            return new SessionCreatedEventHandler(this);
        }
    }

    static class SessionClosedEventHandler
    extends Handler<SessionClosedEvent> {
        SessionClosedEventHandler(Executor executor) {
            super(executor);
        }

        SessionClosedEventHandler(SessionClosedEventHandler other) {
            super(other);
        }

        @Override
        public Handler<SessionClosedEvent> copyOf() {
            return new SessionClosedEventHandler(this);
        }
    }

    static class SessionFireEventHandler
    extends Handler<SessionFireEvent> {
        SessionFireEventHandler(Executor executor) {
            super(executor);
        }

        SessionFireEventHandler(SessionFireEventHandler other) {
            super(other);
        }

        @Override
        public Handler<SessionFireEvent> copyOf() {
            return new SessionFireEventHandler(this);
        }
    }

    static class EnvironmentChangeEventHandler
    extends Handler<EnvironmentChangeEvent> {
        EnvironmentChangeEventHandler(Executor executor) {
            super(executor);
        }

        EnvironmentChangeEventHandler(EnvironmentChangeEventHandler other) {
            super(other);
        }

        @Override
        public Handler<EnvironmentChangeEvent> copyOf() {
            return new EnvironmentChangeEventHandler(this);
        }
    }
}

