/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.evrete.api.CompiledPredicate;
import org.evrete.api.LhsField;
import org.evrete.api.LiteralPredicate;
import org.evrete.api.RhsContext;
import org.evrete.api.Rule;
import org.evrete.api.RuleCompiledSources;
import org.evrete.api.RuleDescriptor;
import org.evrete.api.RuntimeContext;
import org.evrete.runtime.AbstractActiveRule;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.ActiveEvaluatorGenerator;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.DefaultConditionManager;
import org.evrete.runtime.DefaultLhsBuilder;
import org.evrete.runtime.DefaultNamedTypeResolver;
import org.evrete.runtime.DefaultRuleBuilder;
import org.evrete.runtime.DefaultRuleLiteralData;
import org.evrete.runtime.DefaultRuleSetBuilder;
import org.evrete.runtime.FactType;
import org.evrete.runtime.KnowledgeFactGroup;
import org.evrete.runtime.KnowledgeLhs;
import org.evrete.runtime.LhsConditionDH;
import org.evrete.runtime.RuleBuilderActiveConditions;
import org.evrete.runtime.evaluation.DefaultEvaluatorHandle;

public final class KnowledgeRule
extends AbstractActiveRule<KnowledgeFactGroup, KnowledgeLhs, AbstractRuntime<?, ?>>
implements RuleDescriptor {
    private KnowledgeRule(AbstractRuntime<?, ?> runtime, DefaultRuleBuilder<?> other, int salience, KnowledgeLhs knowledgeLhs) {
        super(runtime, other, salience, knowledgeLhs);
    }

    static KnowledgeRule buildRule(AbstractRuntime<?, ?> runtime, DefaultRuleBuilder<?> rule, RuleBuilderActiveConditions lhsConditions, int salience) {
        Collection factDeclarations = ((DefaultNamedTypeResolver)((Object)rule.getLhs())).rawValues();
        ArrayList<FactType> factTypes = new ArrayList<FactType>(factDeclarations.size());
        for (DefaultLhsBuilder.Fact lhsFact : factDeclarations) {
            Set<DefaultEvaluatorHandle> alphaHandles = lhsConditions.getAlphaConditionsOf(lhsFact.getVarName());
            FactType factType = runtime.buildFactType(lhsFact, alphaHandles);
            factTypes.add(factType);
        }
        KnowledgeLhs knowledgeLhs = KnowledgeLhs.factory(factTypes, lhsConditions);
        return new KnowledgeRule(runtime, rule, salience, knowledgeLhs);
    }

    static <C extends RuntimeContext<C>> List<KnowledgeRule> buildRuleDescriptors(AbstractRuntime<?, C> runtime, DefaultRuleSetBuilder<C> ruleSetBuilder, Collection<RuleCompiledSources<DefaultRuleLiteralData, DefaultRuleBuilder<?>, DefaultConditionManager.Literal>> compiledSources) {
        int currentRuleCount = runtime.getRules().size();
        List<DefaultRuleBuilder<C>> rules = ruleSetBuilder.getRuleBuilders();
        IdentityHashMap mapping = new IdentityHashMap();
        for (RuleCompiledSources<DefaultRuleLiteralData, DefaultRuleBuilder<?>, DefaultConditionManager.Literal> entry : compiledSources) {
            Rule ruleBuilder = entry.getSources().getRule();
            mapping.put(ruleBuilder, entry);
        }
        ArrayList<KnowledgeRule> descriptors = new ArrayList<KnowledgeRule>(rules.size());
        ActiveEvaluatorGenerator evalCtx = runtime.getEvaluatorsContext();
        for (DefaultRuleBuilder<C> ruleBuilder : rules) {
            String literalRhs;
            if (runtime.ruleExists(ruleBuilder.getName())) {
                throw new IllegalArgumentException("Rule '" + ruleBuilder.getName() + "' already exists");
            }
            int salience = ruleBuilder.getSalience();
            if (salience == Integer.MIN_VALUE) {
                salience = -1 * (currentRuleCount + 1);
            }
            RuleBuilderActiveConditions ruleConditions = new RuleBuilderActiveConditions();
            DefaultConditionManager builderConditions = ruleBuilder.getConditionManager();
            for (LhsConditionDH<String, ActiveField> evaluator : builderConditions.getEvaluators()) {
                ruleConditions.add(evaluator);
            }
            Collection<DefaultConditionManager.Literal> literalConditions = builderConditions.getLiterals();
            if (!literalConditions.isEmpty()) {
                RuleCompiledSources compiledData = (RuleCompiledSources)mapping.get(ruleBuilder);
                if (compiledData == null) {
                    throw new IllegalStateException("No compiled data for literal sources");
                }
                IdentityHashMap conditionMap = new IdentityHashMap();
                for (CompiledPredicate compiledPredicate : compiledData.conditions()) {
                    conditionMap.put(compiledPredicate.getSource(), compiledPredicate);
                }
                for (LiteralPredicate literalPredicate : literalConditions) {
                    CompiledPredicate compiled = (CompiledPredicate)conditionMap.get(literalPredicate);
                    if (compiled == null) {
                        throw new IllegalStateException("Compiled condition not found for " + String.valueOf(literalPredicate));
                    }
                    LhsField.Array<String, ActiveField> descriptor = runtime.toActiveFields(compiled.resolvedFields());
                    DefaultEvaluatorHandle handle = evalCtx.addEvaluator(compiled.getPredicate(), ((DefaultConditionManager.Literal)compiled.getSource()).getComplexity(), descriptor);
                    ((DefaultConditionManager.Literal)compiled.getSource()).getHandle().complete(handle);
                    ruleConditions.add(new LhsConditionDH<String, ActiveField>(handle, descriptor));
                }
            }
            if ((literalRhs = ruleBuilder.getLiteralRhs()) != null) {
                RuleCompiledSources compiledData = (RuleCompiledSources)mapping.get(ruleBuilder);
                if (compiledData == null) {
                    throw new IllegalStateException("No compiled data for literal sources");
                }
                Consumer<RhsContext> compiledRhs = compiledData.rhs();
                if (compiledRhs == null) {
                    throw new IllegalStateException("No compiled RHS for literal actions");
                }
                ruleBuilder.setRhs(compiledRhs);
            }
            KnowledgeRule descriptor = KnowledgeRule.buildRule(runtime, ruleBuilder, ruleConditions, salience);
            descriptors.add(descriptor);
            ++currentRuleCount;
        }
        return descriptors;
    }

    @Override
    public KnowledgeRule set(String property, Object value) {
        super.set(property, value);
        return this;
    }
}

