/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.evrete.api.FactHandle;
import org.evrete.api.MemoryStreaming;
import org.evrete.api.Type;
import org.evrete.api.spi.FactStorage;
import org.evrete.api.spi.GroupingReteMemory;
import org.evrete.api.spi.ValueIndexer;
import org.evrete.collections.ArrayMap;
import org.evrete.runtime.AbstractRuleSession;
import org.evrete.runtime.ActiveType;
import org.evrete.runtime.AlphaAddress;
import org.evrete.runtime.DefaultFactHandle;
import org.evrete.runtime.FactFieldValues;
import org.evrete.runtime.FactHolder;
import org.evrete.runtime.FactType;
import org.evrete.runtime.Mask;
import org.evrete.runtime.TypeAlphaMemory;
import org.evrete.runtime.TypeMemory;
import org.evrete.runtime.evaluation.AlphaConditionHandle;
import org.evrete.util.CompletionManager;
import org.evrete.util.FactStorageWrapper;
import org.evrete.util.GroupingReteMemoryWrapper;

public class SessionMemory
implements MemoryStreaming {
    private static final Logger LOGGER = Logger.getLogger(SessionMemory.class.getName());
    private final ArrayMap<ActiveType.Idx, TypeMemory> typedMemories = new ArrayMap();
    private final ArrayMap<AlphaAddress, TypeAlphaMemory> alphaMemories = new ArrayMap();
    private final CompletionManager<ActiveType.Idx, Void> typeMemoryDeployments = new CompletionManager();
    private final AtomicLong allocationCounter = new AtomicLong();
    private final AbstractRuleSession<?> runtime;

    SessionMemory(AbstractRuleSession<?> runtime) {
        this.runtime = runtime;
    }

    void clear() {
        this.typedMemories.forEach(FactStorageWrapper::clear);
        this.alphaMemories.forEach(GroupingReteMemoryWrapper::clear);
    }

    ArrayMap<AlphaAddress, TypeAlphaMemory> getAlphaMemories() {
        return this.alphaMemories;
    }

    CompletionManager<ActiveType.Idx, Void> getTypeMemoryDeployments() {
        return this.typeMemoryDeployments;
    }

    private Stream<TypeMemory> memoryStream() {
        return this.typedMemories.values();
    }

    private Stream<TypeMemory> memoryStream(String logicalType) {
        return this.memoryStream().filter(typeMemory -> typeMemory.getLogicalType().equals(logicalType));
    }

    private Stream<TypeMemory> memoryStream(Class<?> javaType) {
        return this.memoryStream().filter(memory -> javaType.isAssignableFrom(memory.getJavaType()));
    }

    @Override
    public Stream<Map.Entry<FactHandle, Object>> streamFactEntries() {
        return this.memoryStream().flatMap(TypeMemory::streamFactEntries);
    }

    @Override
    public <T> Stream<Map.Entry<FactHandle, T>> streamFactEntries(String type) {
        return this.memoryStream(type).flatMap(TypeMemory::streamFactEntries);
    }

    @Override
    public <T> Stream<Map.Entry<FactHandle, T>> streamFactEntries(Class<T> type) {
        return this.memoryStream(type).flatMap(TypeMemory::streamFactEntries);
    }

    TypeMemory getTypeMemory(ActiveType.Idx activeType) {
        return this.typedMemories.getChecked(activeType);
    }

    public TypeMemory getTypeMemory(FactType factType) {
        return this.getTypeMemory(factType.typeId());
    }

    TypeMemory getTypeMemory(DefaultFactHandle handle) {
        return this.getTypeMemory(handle.getType());
    }

    CompletableFuture<Void> allocateMemoryIfNotExists(ActiveType.Idx typeId, Set<AlphaAddress> alphaAddresses) {
        return this.typeMemoryDeployments.enqueue(typeId, id -> CompletableFuture.runAsync(() -> this.allocate((ActiveType.Idx)id, alphaAddresses), this.runtime.getService().getExecutor()));
    }

    private void allocate(ActiveType.Idx typeId, Set<AlphaAddress> alphaAddresses) {
        TypeMemory newTypeMemory;
        long allocationId = this.allocationCounter.getAndIncrement();
        LOGGER.fine(() -> "Memory allocation [" + allocationId + "] START. Type: " + String.valueOf(typeId) + ", alpha locations:" + String.valueOf(alphaAddresses) + " ....");
        TypeMemory existing = this.typedMemories.get(typeId);
        ActiveType newActiveType = this.runtime.getActiveType(typeId);
        if (existing == null) {
            newTypeMemory = new TypeMemory(this.runtime, newActiveType);
            for (AlphaAddress alphaAddress2 : alphaAddresses) {
                GroupingReteMemory<DefaultFactHandle> alphaStorage = this.runtime.newAlphaMemoryStorage();
                this.alphaMemories.put(alphaAddress2, new TypeAlphaMemory(alphaStorage, alphaAddress2));
            }
            LOGGER.fine(() -> "Type memory allocation [" + allocationId + "]. Blank instances of type memory and alpha locations have been created");
        } else {
            Collection<TypeAlphaMemory> newAlphaMemories;
            int fieldsOfNew;
            int fieldsExisting = existing.getFieldCount();
            if (fieldsExisting == (fieldsOfNew = newActiveType.getFieldCount())) {
                newTypeMemory = existing;
                Set exitingAlphaLocations = this.alphaMemories.values().map(TypeAlphaMemory::getAlphaAddress).collect(Collectors.toSet());
                Set<AlphaAddress> newAlphaAddresses = alphaAddresses.stream().filter(alphaAddress -> !exitingAlphaLocations.contains(alphaAddress)).collect(Collectors.toSet());
                if (newAlphaAddresses.isEmpty()) {
                    LOGGER.fine(() -> "Type memory allocation [" + allocationId + "]. The allocation has the same fields no new alpha memories; no action is required");
                    newAlphaMemories = Collections.emptyList();
                } else {
                    LOGGER.fine(() -> "Type memory allocation [" + allocationId + "]. New alpha locations were found: " + String.valueOf(newAlphaAddresses));
                    newAlphaMemories = this.rebuildAlphas(newTypeMemory, newAlphaAddresses, allocationId);
                }
            } else {
                LOGGER.fine(() -> "Type memory allocation [" + allocationId + "]. Existing fields: " + fieldsExisting + ", new fields count: " + fieldsOfNew + ". Fact storage will be rebuilt.");
                newTypeMemory = this.rebuildStorage(existing, newActiveType, allocationId);
                newAlphaMemories = this.rebuildAlphas(newTypeMemory, newActiveType.getKnownAlphaLocations(), allocationId);
            }
            for (TypeAlphaMemory alphaMemory : newAlphaMemories) {
                this.alphaMemories.put(alphaMemory.getAlphaAddress(), alphaMemory);
            }
        }
        this.typedMemories.put(typeId, newTypeMemory);
        LOGGER.fine(() -> "Type memory allocation [" + allocationId + "] END");
    }

    private Collection<TypeAlphaMemory> rebuildAlphas(TypeMemory newTypeMemory, Set<AlphaAddress> alphaLocations, long allocationId) {
        ArrayMap<AlphaAddress, TypeAlphaMemory> resultMap = new ArrayMap<AlphaAddress, TypeAlphaMemory>(alphaLocations.size());
        for (AlphaAddress alphaAddress : alphaLocations) {
            resultMap.put(alphaAddress, new TypeAlphaMemory(this.runtime.newAlphaMemoryStorage(), alphaAddress));
            LOGGER.fine(() -> "Type memory allocation [" + allocationId + "]. Created new alpha memory for location " + String.valueOf(alphaAddress));
        }
        ActiveType newType = newTypeMemory.getType();
        Type type = this.runtime.getTypeResolver().getType(newType.getValue().getName());
        ((Stream)newTypeMemory.stream().parallel()).forEach(entry -> {
            FactHolder factHolder = (FactHolder)entry.getValue();
            FactFieldValues fieldValues = newType.readFactValue(type, factHolder.getFact());
            Mask<AlphaConditionHandle> alphaTests = this.runtime.alphaConditionResults(newType, fieldValues);
            Collection<AlphaAddress> matchingLocations = AlphaAddress.matchingLocations(alphaTests, alphaLocations);
            for (AlphaAddress alphaAddress : matchingLocations) {
                ((TypeAlphaMemory)resultMap.getChecked(alphaAddress)).insert(factHolder.getFieldValuesId(), factHolder.getHandle());
            }
        });
        return resultMap.values().peek(GroupingReteMemoryWrapper::commit).collect(Collectors.toList());
    }

    TypeMemory rebuildStorage(TypeMemory source, ActiveType newType, long allocationId) {
        FactStorage<DefaultFactHandle, FactHolder> newStorage = this.runtime.newTypeFactStorage();
        ValueIndexer<FactFieldValues> newValueIndexer = this.runtime.newFieldValuesIndexer();
        Type type = this.runtime.getTypeResolver().getType(newType.getValue().getName());
        AtomicLong factCounter = new AtomicLong();
        ((Stream)source.stream().parallel()).forEach(entry -> {
            DefaultFactHandle handle = (DefaultFactHandle)entry.getKey();
            FactHolder factHolder = (FactHolder)entry.getValue();
            Object fact = factHolder.getFact();
            long valueId = factHolder.getFieldValuesId();
            FactFieldValues fieldValues = newType.readFactValue(type, fact);
            FactHolder newFactHolder = new FactHolder(handle, valueId, fact);
            newValueIndexer.assignId(valueId, fieldValues);
            newStorage.insert(handle, newFactHolder);
            factCounter.incrementAndGet();
        });
        LOGGER.fine(() -> "Type memory allocation [" + allocationId + "]. Storage rebuild completed for " + String.valueOf(newType) + ", total facts processed: [" + factCounter.get() + "]");
        return new TypeMemory(newType, newStorage, newValueIndexer);
    }

    public TypeAlphaMemory getAlphaMemory(AlphaAddress alphaAddress) {
        return this.alphaMemories.getChecked(alphaAddress);
    }
}

