/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.evaluation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.evrete.api.WorkUnit;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.FactType;
import org.evrete.runtime.LhsConditionDH;
import org.evrete.runtime.Mask;
import org.evrete.runtime.evaluation.DefaultEvaluatorHandle;

public class BetaEvaluator
implements WorkUnit {
    private final LhsConditionDH<FactType, ActiveField>[] components;
    private final double complexity;
    private final Mask<FactType> typeMask;

    public BetaEvaluator(Mask<FactType> typeMask, Set<LhsConditionDH<FactType, ActiveField>> conditions) {
        ArrayList<LhsConditionDH<FactType, ActiveField>> sortedConditions = new ArrayList<LhsConditionDH<FactType, ActiveField>>(conditions);
        sortedConditions.sort((c1, c2) -> {
            int cmp = Double.compare(((DefaultEvaluatorHandle)c1.getCondition()).getComplexity(), ((DefaultEvaluatorHandle)c2.getCondition()).getComplexity());
            if (cmp == 0) {
                return Integer.compare(c1.getDescriptor().length(), c2.getDescriptor().length());
            }
            return cmp;
        });
        double c = 0.0;
        int i = 0;
        this.components = new LhsConditionDH[sortedConditions.size()];
        for (LhsConditionDH lhsConditionDH : sortedConditions) {
            c += ((DefaultEvaluatorHandle)lhsConditionDH.getCondition()).getComplexity();
            this.components[i++] = lhsConditionDH;
        }
        this.complexity = c;
        this.typeMask = typeMask;
    }

    public LhsConditionDH<FactType, ActiveField>[] getComponents() {
        return this.components;
    }

    public Mask<FactType> getTypeMask() {
        return this.typeMask;
    }

    @Override
    public double getComplexity() {
        return this.complexity;
    }

    public String toString() {
        return Arrays.toString(this.components);
    }

    public static int compare(BetaEvaluator e1, BetaEvaluator e2) {
        int typesInvolved2;
        int typesInvolved1 = e1.getTypeMask().cardinality();
        int cmp1 = Integer.compare(typesInvolved1, typesInvolved2 = e2.getTypeMask().cardinality());
        if (cmp1 == 0) {
            return Double.compare(e1.getComplexity(), e2.getComplexity());
        }
        return cmp1;
    }
}

