/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.rete;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.evrete.runtime.rete.ReteNode;
import org.evrete.util.CommonUtils;

public final class ReteGraph<B extends ReteNode<B>, E extends B, C extends B> {
    private final C terminalNode;

    private ReteGraph(C terminalNode) {
        if (terminalNode.sourceNodes().length < 1) {
            throw new IllegalArgumentException("The terminal node must have at least one source node");
        }
        this.terminalNode = terminalNode;
    }

    public C terminalNode() {
        return this.terminalNode;
    }

    public void forEachConditionNode(Consumer<C> action) {
        this.forEachNode(b -> {
            if (b.isConditionNode()) {
                action.accept(b);
            }
        });
    }

    public void forEachNode(Consumer<B> action) {
        this.forEachNode(this.terminalNode, action);
    }

    private void forEachNode(B parent, Consumer<B> action) {
        action.accept(parent);
        for (ReteNode sourceNode : parent.sourceNodes()) {
            this.forEachNode(sourceNode, action);
        }
    }

    public <B1 extends ReteNode<B1>, E1 extends B1, C1 extends B1> ReteGraph<B1, E1, C1> transform(Class<B1> nodeType, BiFunction<C, B1[], C1> conditionNodeMapper, Function<E, E1> entryNodeMapper) {
        B1 newTerminalNode = this.transformNode(nodeType, this.terminalNode, conditionNodeMapper, entryNodeMapper);
        return new ReteGraph<B, E, B1>(newTerminalNode);
    }

    private <B1 extends ReteNode<B1>, E1 extends B1, C1 extends B1> B1 transformNode(Class<B1> nodeType, B node, BiFunction<C, B1[], C1> conditionNodeMapper, Function<E, E1> entryNodeMapper) {
        if (((ReteNode)node).isConditionNode()) {
            B conditionNode = node;
            ReteNode[] sources = conditionNode.sourceNodes();
            ReteNode[] newSources = (ReteNode[])CommonUtils.array(nodeType, sources.length);
            for (int i = 0; i < sources.length; ++i) {
                newSources[i] = this.transformNode(nodeType, sources[i], conditionNodeMapper, entryNodeMapper);
            }
            return (B1)((ReteNode)conditionNodeMapper.apply(conditionNode, newSources));
        }
        B entryNode = node;
        return (B1)((ReteNode)entryNodeMapper.apply(entryNode));
    }

    public static <N extends ReteNode<N>, E extends N, T extends N> ReteGraph<N, E, T> fromTerminalNode(T terminalNode) {
        return new ReteGraph(terminalNode);
    }
}

