/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.rete;

import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import org.evrete.api.spi.MemoryScope;
import org.evrete.runtime.AbstractRuleSessionBase;
import org.evrete.runtime.AlphaAddress;
import org.evrete.runtime.DeltaMemoryMode;
import org.evrete.runtime.SessionMemory;
import org.evrete.runtime.TypeAlphaMemory;
import org.evrete.runtime.rete.ConditionMemory;
import org.evrete.runtime.rete.ReteKnowledgeEntryNode;
import org.evrete.runtime.rete.ReteSessionNode;
import org.evrete.util.MappingIterator;

public class ReteSessionEntryNode
extends ReteSessionNode {
    private final SessionMemory memory;
    private final AlphaAddress alphaAddress;

    public ReteSessionEntryNode(AbstractRuleSessionBase<?> session, ReteKnowledgeEntryNode knowledgeEntryNode) {
        super(session, knowledgeEntryNode, ReteSessionNode.EMPTY_ARRAY);
        this.memory = session.getMemory();
        this.alphaAddress = knowledgeEntryNode.factType.getAlphaAddress();
    }

    @Override
    String debugName() {
        return "{fact='" + this.getNodeFactTypes()[0].getVarName() + "', memory=" + String.valueOf(this.alphaAddress) + "}";
    }

    private TypeAlphaMemory alphaMemory() {
        return this.memory.getAlphaMemory(this.alphaAddress);
    }

    @Override
    public CompletableFuture<Void> computeDeltaMemoryAsync(DeltaMemoryMode mode) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    Iterator<ConditionMemory.MemoryEntry> iterator(MemoryScope scope) {
        return new MappingIterator<Long, ConditionMemory.MemoryEntry>(this.alphaMemory().keyIterator(scope), fieldValues -> ConditionMemory.MemoryEntry.fromEntryNode(fieldValues, scope));
    }

    public String toString() {
        return "{factType='" + this.getNodeFactTypes()[0].getVarName() + "'}";
    }
}

