/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.rete;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.evrete.api.spi.MemoryScope;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.ActiveType;
import org.evrete.runtime.DeltaMemoryMode;
import org.evrete.runtime.FactType;
import org.evrete.runtime.MapOfList;
import org.evrete.runtime.StoredCondition;
import org.evrete.runtime.evaluation.DefaultEvaluatorHandle;
import org.evrete.runtime.rete.ConditionMemory;
import org.evrete.runtime.rete.ReteKnowledgeNode;
import org.evrete.runtime.rete.ReteNode;

public abstract class ReteSessionNode
extends ReteNode<ReteSessionNode> {
    public static final ReteSessionNode[] EMPTY_ARRAY = new ReteSessionNode[0];
    private final AbstractRuntime<?, ?> runtime;
    private final FactType[] nodeFactTypes;
    private final int[][] nodeFactTypesMapping;
    private final MapOfList<ActiveType.Idx, Integer> typeToIndices;

    public ReteSessionNode(AbstractRuntime<?, ?> runtime, ReteKnowledgeNode parent, ReteSessionNode[] sourceNodes) {
        super((ReteNode[])sourceNodes);
        this.runtime = runtime;
        this.nodeFactTypes = parent.getNodeFactTypes();
        this.nodeFactTypesMapping = parent.getNodeFactTypesMapping();
        this.typeToIndices = parent.getTypeToIndices();
    }

    public Collection<Integer> nodeIndices(ActiveType.Idx type) {
        return this.typeToIndices.getOrDefault(type, (Integer)((Object)Collections.emptyList()));
    }

    public FactType[] getNodeFactTypes() {
        return this.nodeFactTypes;
    }

    abstract String debugName();

    String debugName(ReteSessionNode[] nodes) {
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        for (ReteSessionNode node : nodes) {
            joiner.add("'" + node.debugName() + "'");
        }
        return joiner.toString();
    }

    int location(int sourceIndex, int inSourceIndex) {
        return this.nodeFactTypesMapping[sourceIndex][inSourceIndex];
    }

    protected ExecutorService getExecutor() {
        return this.runtime.getService().getExecutor();
    }

    protected StoredCondition getActiveEvaluator(DefaultEvaluatorHandle handle) {
        return this.runtime.getEvaluatorsContext().get(handle, false);
    }

    public abstract CompletableFuture<Void> computeDeltaMemoryAsync(DeltaMemoryMode var1);

    abstract Iterator<ConditionMemory.MemoryEntry> iterator(MemoryScope var1);
}

