/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal.compiler;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.evrete.api.spi.SourceCompiler;
import org.evrete.spi.minimal.compiler.ClassLoaderWrapper;
import org.evrete.spi.minimal.compiler.DestinationClassObject;
import org.evrete.spi.minimal.compiler.InMemoryFileManager;
import org.evrete.spi.minimal.compiler.JavaSourceObject;
import org.evrete.util.CompilationException;

public class DefaultSourceCompiler
implements SourceCompiler {
    private static final String COMPILER_PARAM_OPTION = "-parameters";
    private final ClassLoaderWrapper classLoader;
    private final JavaCompiler compiler;

    public DefaultSourceCompiler(ClassLoader classLoader) {
        this.classLoader = new ClassLoaderWrapper(classLoader);
        this.compiler = Objects.requireNonNull(ToolProvider.getSystemJavaCompiler(), "No Java compiler provided by this platform");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <S extends SourceCompiler.ClassSource> Collection<SourceCompiler.Result<S>> compile(Collection<S> sources) throws CompilationException {
        HashMap<String, SourceCompiler.ClassSource> sourcesByClassName = new HashMap<String, SourceCompiler.ClassSource>(sources.size());
        for (SourceCompiler.ClassSource s : sources) {
            sourcesByClassName.put(s.binaryName(), s);
        }
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        try (StandardJavaFileManager systemFm = this.compiler.getStandardFileManager(diagnostics, null, null);){
            Collection parsedSources = sources.stream().map(JavaSourceObject::new).collect(Collectors.toList());
            try (InMemoryFileManager fm = new InMemoryFileManager(systemFm, this.classLoader);){
                List<String> parameters = this.compiler.isSupportedOption(COMPILER_PARAM_OPTION) < 0 ? Collections.emptyList() : Collections.singletonList(COMPILER_PARAM_OPTION);
                boolean success = this.compiler.getTask(null, fm, diagnostics, parameters, null, parsedSources).call();
                if (success) {
                    LinkedList<String> binaryNames = new LinkedList<String>();
                    for (DestinationClassObject compiled : fm.getOutput()) {
                        this.classLoader.defineNewClass(compiled.getBinaryName(), compiled.getBytes());
                        binaryNames.add(compiled.getBinaryName());
                    }
                    ArrayList compiled = new ArrayList(binaryNames.size());
                    Object object = binaryNames.iterator();
                    while (true) {
                        if (!object.hasNext()) {
                            object = compiled.stream().map(cl -> {
                                String binaryName = cl.getName();
                                final SourceCompiler.ClassSource source = (SourceCompiler.ClassSource)sourcesByClassName.get(binaryName);
                                if (source == null) {
                                    return null;
                                }
                                return new SourceCompiler.Result<S>(){
                                    final /* synthetic */ Class val$cl;
                                    {
                                        this.val$cl = clazz;
                                    }

                                    @Override
                                    public S getSource() {
                                        return source;
                                    }

                                    @Override
                                    public Class<?> getCompiledClass() {
                                        return this.val$cl;
                                    }
                                };
                            }).filter(Objects::nonNull).collect(Collectors.toList());
                            return object;
                        }
                        String binaryName = (String)object.next();
                        try {
                            Class<?> cl2 = Class.forName(binaryName, false, this.classLoader);
                            compiled.add(cl2);
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalStateException("Class has been compiled, but can not be resolved", e);
                        }
                    }
                }
                LinkedList<String> otherErrors = new LinkedList<String>();
                IdentityHashMap<SourceCompiler.ClassSource, List<String>> errorSources = new IdentityHashMap<SourceCompiler.ClassSource, List<String>>();
                Iterator iterator = diagnostics.getDiagnostics().iterator();
                while (iterator.hasNext()) {
                    Diagnostic diagnostic = iterator.next();
                    if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
                    JavaFileObject errorSource = (JavaFileObject)diagnostic.getSource();
                    String err = diagnostic.toString();
                    if (errorSource instanceof JavaSourceObject) {
                        JavaSourceObject javaSource = (JavaSourceObject)errorSource;
                        errorSources.computeIfAbsent(javaSource.getSource(), k -> new ArrayList()).add(err);
                        continue;
                    }
                    otherErrors.add(err);
                }
                throw new CompilationException(otherErrors, errorSources);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

