/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class CompletionManager<K, T> {
    private final ConcurrentHashMap<K, CompletableFuture<T>> completions = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<T> enqueue(K key, Function<? super K, ? extends CompletableFuture<T>> mappingFunction) {
        ConcurrentHashMap<K, CompletableFuture<T>> concurrentHashMap = this.completions;
        synchronized (concurrentHashMap) {
            CompletableFuture<T> existing = this.completions.get(key);
            CompletionStage<T> newFuture = existing == null ? mappingFunction.apply(key) : existing.thenCompose(t -> (CompletionStage)mappingFunction.apply(key));
            CompletionStage chained = ((CompletableFuture)newFuture).whenComplete((t, throwable) -> this.completions.remove(key));
            this.completions.put(key, (CompletableFuture<T>)chained);
            return chained;
        }
    }

    public int taskCount() {
        return this.completions.size();
    }
}

