/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class EnumCombinationIterator<E extends Enum<E>>
implements Iterator<E[]> {
    private final E[] enums;
    private final E[] state;
    private final long totalCombinations;
    private long currentCounter;

    public EnumCombinationIterator(Class<E> enumClass, E[] state) {
        this.enums = (Enum[])enumClass.getEnumConstants();
        this.state = state;
        this.totalCombinations = BigInteger.valueOf(this.enums.length).pow(state.length).longValue();
        this.currentCounter = 0L;
        this.updateCurrentCombination();
    }

    @Override
    public boolean hasNext() {
        return this.currentCounter < this.totalCombinations;
    }

    private void updateCurrentCombination() {
        long counter = this.currentCounter;
        for (int i = this.state.length - 1; i >= 0; --i) {
            int index = (int)(counter % (long)this.enums.length);
            this.state[i] = this.enums[index];
            counter /= (long)this.enums.length;
        }
    }

    @Override
    public E[] next() {
        if (this.hasNext()) {
            ++this.currentCounter;
            this.updateCurrentCombination();
            return this.state;
        }
        throw new NoSuchElementException();
    }
}

