/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.evrete.api.NamedType;
import org.evrete.api.TypeField;
import org.evrete.util.CommonUtils;

public class LhsField<Fact, Field> {
    private final Fact fact;
    private final Field field;

    public LhsField(Fact fact, Field field) {
        this.fact = fact;
        this.field = field;
    }

    public LhsField(LhsField<Fact, ?> other, Field field) {
        this(other.fact, field);
    }

    public LhsField(Fact fact, LhsField<?, Field> other) {
        this(fact, other.field);
    }

    public Fact fact() {
        return this.fact;
    }

    public Field field() {
        return this.field;
    }

    public static LhsField<String, String> parseDottedVariable(String arg) {
        int dotPos = arg.indexOf(46);
        if (dotPos < 0) {
            return new LhsField<String, String>(arg, (String)null);
        }
        String factName = arg.substring(0, dotPos);
        String fieldName = arg.substring(dotPos + 1);
        return new LhsField<String, String>(factName, fieldName);
    }

    public String toString() {
        return "{fact=" + String.valueOf(this.fact) + ", field=" + String.valueOf(this.field) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LhsField lhsField = (LhsField)o;
        return Objects.equals(this.fact, lhsField.fact) && Objects.equals(this.field, lhsField.field);
    }

    public int hashCode() {
        return Objects.hash(this.fact, this.field);
    }

    public static final class Array<Fact, Field> {
        private final LhsField<Fact, Field>[] fields;

        public Array(LhsField<Fact, Field>[] fields) {
            this.fields = fields;
        }

        public Array(List<LhsField<Fact, Field>> arg) {
            this.fields = new LhsField[arg.size()];
            int i = 0;
            for (LhsField<Fact, Field> f : arg) {
                this.fields[i++] = f;
            }
        }

        public LhsField<Fact, Field> get(int index) {
            return this.fields[index];
        }

        public int length() {
            return this.fields.length;
        }

        public <Fact1, Field1> Array<Fact1, Field1> transform(Function<LhsField<Fact, Field>, LhsField<Fact1, Field1>> factMapper) {
            LhsField[] newFields = new LhsField[this.fields.length];
            for (int i = 0; i < this.fields.length; ++i) {
                newFields[i] = factMapper.apply(this.fields[i]);
            }
            return new Array<Fact, Field>(newFields);
        }

        public String toString() {
            return Arrays.toString(this.fields);
        }

        public static Array<String, String> fromDottedVariables(String[] fieldNames) {
            ArrayList list = new ArrayList(fieldNames.length);
            for (String fieldName : fieldNames) {
                LhsField<String, String> parsed = LhsField.parseDottedVariable(fieldName);
                list.add(parsed);
            }
            return new Array<String, String>(list);
        }

        public static Array<String, TypeField> toFields(String[] fieldNames, NamedType.Resolver namedTypeResolver) {
            Array<String, String> lhsFields = Array.fromDottedVariables(fieldNames);
            return lhsFields.transform(lhsField -> CommonUtils.toTypeField(lhsField, namedTypeResolver));
        }
    }
}

