/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.collections;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class LongKeyMap<T>
implements Iterable<T> {
    private static final int INITIAL_CAPACITY = 16;
    private static final float LOAD_FACTOR = 0.75f;
    private static final float SHRINK_FACTOR = 0.25f;
    private Entry<T>[] table;
    private int size;
    private int threshold;
    private int shrinkThreshold;
    private final Object lock = new Object();

    public LongKeyMap() {
        this.table = new Entry[16];
        this.threshold = 12;
        this.shrinkThreshold = 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LongKeyMap(LongKeyMap<T> other) {
        Object object = other.lock;
        synchronized (object) {
            this.table = (Entry[])other.table.clone();
            this.threshold = other.threshold;
            this.shrinkThreshold = other.shrinkThreshold;
            this.size = other.size;
        }
    }

    private int hash(long key) {
        return Integer.hashCode((int)key) & this.table.length - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T put(long key, T value) {
        Object object = this.lock;
        synchronized (object) {
            int index = this.hash(key);
            Entry<T> entry = this.table[index];
            Entry<T> prev = null;
            while (entry != null) {
                if (entry.key == key) {
                    Object oldValue = entry.value;
                    entry.value = value;
                    return oldValue;
                }
                prev = entry;
                entry = entry.next;
            }
            if (prev == null) {
                this.table[index] = new Entry<T>(key, value);
            } else {
                prev.next = new Entry<T>(key, value);
            }
            if (++this.size > this.threshold) {
                this.resize(this.table.length * 2);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            Entry[] newTable = new Entry[16];
            this.table = newTable;
            this.size = 0;
            this.threshold = 12;
            this.shrinkThreshold = 4;
        }
    }

    private Stream<Entry<T>> entries() {
        return Arrays.stream(this.table).filter(Objects::nonNull).flatMap(entry -> {
            Stream.Builder builder = Stream.builder();
            while (entry != null) {
                builder.accept(entry);
                entry = entry.next;
            }
            return builder.build();
        });
    }

    public Stream<T> values() {
        return this.entries().map(entry -> entry.value);
    }

    public Stream<Long> keys() {
        return this.entries().map(entry -> entry.key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T computeIfAbsent(long key, Supplier<T> supplier) {
        T result = this.get(key);
        if (result == null) {
            Object object = this.lock;
            synchronized (object) {
                result = this.get(key);
                if (result == null) {
                    result = supplier.get();
                    this.put(key, result);
                }
            }
        }
        return result;
    }

    public T get(long key) {
        int index = this.hash(key);
        Entry<T> entry = this.table[index];
        while (entry != null) {
            if (entry.key == key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized T remove(long key) {
        Object object = this.lock;
        synchronized (object) {
            int index = this.hash(key);
            Entry<T> entry = this.table[index];
            Entry<T> prev = null;
            while (entry != null) {
                if (entry.key == key) {
                    if (prev == null) {
                        this.table[index] = entry.next;
                    } else {
                        prev.next = entry.next;
                    }
                    --this.size;
                    Object ret = entry.value;
                    if (this.size < this.shrinkThreshold && this.table.length > 16) {
                        this.resize(this.table.length / 2);
                    }
                    return ret;
                }
                prev = entry;
                entry = entry.next;
            }
            return null;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new It();
    }

    private void resize(int newCapacity) {
        Entry<T>[] oldTable = this.table;
        this.table = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * 0.75f);
        this.shrinkThreshold = (int)((float)newCapacity * 0.25f);
        this.size = 0;
        for (Entry<T> entry : oldTable) {
            while (entry != null) {
                this.put(entry.key, entry.value);
                entry = entry.next;
            }
        }
    }

    public int size() {
        return this.size;
    }

    private static class Entry<T> {
        final long key;
        T value;
        Entry<T> next;

        Entry(long key, T value) {
            this.key = key;
            this.value = value;
        }
    }

    private class It
    implements Iterator<T> {
        int bucketIndex = 0;
        Entry<T> currentEntry = null;

        private It() {
        }

        @Override
        public boolean hasNext() {
            if (this.currentEntry != null && this.currentEntry.next != null) {
                return true;
            }
            while (this.bucketIndex < LongKeyMap.this.table.length) {
                if (LongKeyMap.this.table[this.bucketIndex] != null) {
                    return true;
                }
                ++this.bucketIndex;
            }
            return false;
        }

        @Override
        public T next() {
            if (this.currentEntry != null && this.currentEntry.next != null) {
                this.currentEntry = this.currentEntry.next;
            } else {
                while (this.bucketIndex < LongKeyMap.this.table.length && LongKeyMap.this.table[this.bucketIndex] == null) {
                    ++this.bucketIndex;
                }
                if (this.bucketIndex >= LongKeyMap.this.table.length) {
                    throw new NoSuchElementException();
                }
                this.currentEntry = LongKeyMap.this.table[this.bucketIndex];
                ++this.bucketIndex;
            }
            return this.currentEntry.value;
        }
    }
}

