/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.evrete.api.ActivationManager;
import org.evrete.api.FactHandle;
import org.evrete.api.MemoryStreaming;
import org.evrete.api.RuleSession;
import org.evrete.api.RuntimeRule;
import org.evrete.api.events.SessionClosedEvent;
import org.evrete.api.spi.FactStorage;
import org.evrete.api.spi.GroupingReteMemory;
import org.evrete.api.spi.MemoryFactory;
import org.evrete.api.spi.ValueIndexer;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.DefaultFactHandle;
import org.evrete.runtime.FactFieldValues;
import org.evrete.runtime.FactHolder;
import org.evrete.runtime.KnowledgeRuntime;
import org.evrete.runtime.SessionMemory;
import org.evrete.util.SessionCollector;

public abstract class AbstractRuleSessionBase<S extends RuleSession<S>>
extends AbstractRuntime<RuntimeRule, S>
implements RuleSession<S>,
MemoryStreaming {
    private final KnowledgeRuntime knowledge;
    ActivationManager activationManager;
    private volatile boolean active = true;
    protected final boolean warnUnknownTypes;
    private final MemoryFactory<DefaultFactHandle> memoryFactory = this.getService().getMemoryFactoryProvider().instance(this, DefaultFactHandle.class);

    AbstractRuleSessionBase(KnowledgeRuntime knowledge) {
        super(knowledge);
        this.knowledge = knowledge;
        this.activationManager = this.newActivationManager();
        this.warnUnknownTypes = this.getConfiguration().getAsBoolean("evrete.core.warn-unknown-types", true);
    }

    protected abstract S thisInstance();

    public abstract SessionMemory getMemory();

    MemoryFactory<DefaultFactHandle> getMemoryFactory() {
        return this.memoryFactory;
    }

    @Override
    public final S setActivationManager(ActivationManager activationManager) {
        this.activationManager = activationManager;
        return this.thisInstance();
    }

    @Override
    public final ActivationManager getActivationManager() {
        return this.activationManager;
    }

    @Override
    final void _assertActive() {
        if (!this.active) {
            throw new IllegalStateException("Session has been closed");
        }
    }

    @Override
    public final KnowledgeRuntime getParentContext() {
        return this.knowledge;
    }

    @Override
    public final <T> Collector<T, ?, S> asCollector() {
        return new SessionCollector(this.thisInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void closeInner() {
        AbstractRuleSessionBase abstractRuleSessionBase = this;
        synchronized (abstractRuleSessionBase) {
            this.invalidateSession();
            this.broadcast(SessionClosedEvent.class, () -> this);
            this.knowledge.close(this);
        }
    }

    private void invalidateSession() {
        this.active = false;
    }

    public Stream<Map.Entry<FactHandle, Object>> streamFactEntries(boolean closeSession) {
        return this.streamMapper(this.getMemory().streamFactEntries(), closeSession);
    }

    public <T> Stream<Map.Entry<FactHandle, T>> streamFactEntries(String type, boolean closeSession) {
        return this.streamMapper(this.getMemory().streamFactEntries(type), closeSession);
    }

    public <T> Stream<Map.Entry<FactHandle, T>> streamFactEntries(Class<T> type, boolean closeSession) {
        return this.streamMapper(this.getMemory().streamFactEntries(type), closeSession);
    }

    private <T> Stream<T> streamMapper(Stream<T> stream, boolean closeSession) {
        if (closeSession) {
            return (Stream)stream.onClose(this::closeInner);
        }
        return stream;
    }

    public FactStorage<DefaultFactHandle, FactHolder> newTypeFactStorage() {
        return this.getMemoryFactory().newFactStorage(FactHolder.class);
    }

    public ValueIndexer<FactFieldValues> newFieldValuesIndexer() {
        return this.getMemoryFactory().newValueIndexed(FactFieldValues.class);
    }

    public GroupingReteMemory<DefaultFactHandle> newAlphaMemoryStorage() {
        return this.getMemoryFactory().newGroupedFactStorage(DefaultFactHandle.class);
    }
}

