/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import org.evrete.api.Copyable;
import org.evrete.api.EvaluatorHandle;
import org.evrete.api.EvaluatorsContext;
import org.evrete.api.LhsField;
import org.evrete.api.ValuesPredicate;
import org.evrete.api.events.ConditionEvaluationEvent;
import org.evrete.api.events.Events;
import org.evrete.collections.IndexingArrayMap;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.StoredCondition;
import org.evrete.runtime.evaluation.DefaultEvaluatorHandle;

public class ActiveEvaluatorGenerator
extends IndexingArrayMap<InnerKey, InnerKey, DefaultEvaluatorHandle, StoredCondition>
implements Copyable<ActiveEvaluatorGenerator>,
EvaluatorsContext {
    private final Executor executor;

    ActiveEvaluatorGenerator(Executor executor) {
        super((T innerKey) -> innerKey);
        this.executor = executor;
    }

    private ActiveEvaluatorGenerator(ActiveEvaluatorGenerator other) {
        super(other, StoredCondition::copyOf);
        this.executor = other.executor;
    }

    @Override
    protected DefaultEvaluatorHandle generateKey(InnerKey value, int index) {
        return new DefaultEvaluatorHandle(index, value.complexity);
    }

    @Override
    protected StoredCondition generateValue(DefaultEvaluatorHandle handle, InnerKey value) {
        return new StoredCondition(handle.getIndex(), value.predicate, value.complexity, value.fields);
    }

    @Override
    public ValuesPredicate getPredicate(EvaluatorHandle handle) {
        StoredCondition wrapper = this.get((DefaultEvaluatorHandle)handle, true);
        return wrapper == null ? null : (ValuesPredicate)wrapper.getCondition();
    }

    @Override
    public void replacePredicate(EvaluatorHandle handle, ValuesPredicate newPredicate) {
        this.replace((DefaultEvaluatorHandle)handle, newPredicate);
    }

    public synchronized DefaultEvaluatorHandle addEvaluator(ValuesPredicate predicate, double complexity, LhsField.Array<String, ActiveField> fields) {
        InnerKey key = new InnerKey(predicate, complexity, fields);
        Map.Entry entry = this.getOrCreateEntry(key);
        return (DefaultEvaluatorHandle)entry.getKey();
    }

    @Override
    public Events.Publisher<ConditionEvaluationEvent> publisher(EvaluatorHandle handle) {
        return this.get((DefaultEvaluatorHandle)handle, false).getCreatePublisher(this.executor);
    }

    @Override
    public void forEach(BiConsumer<EvaluatorHandle, ValuesPredicate> consumer) {
        super.forEach((Stored storedCondition) -> consumer.accept(storedCondition.getHandle(), (ValuesPredicate)storedCondition.getCondition()));
    }

    private void replace(DefaultEvaluatorHandle handle, ValuesPredicate predicate) {
        this.get(handle, false).setPredicate(predicate);
    }

    public StoredCondition get(DefaultEvaluatorHandle handle, boolean returnNull) {
        StoredCondition result = (StoredCondition)super.get(handle);
        if (result == null) {
            if (returnNull) {
                return null;
            }
            throw new IllegalArgumentException("Unknown evaluator " + String.valueOf(handle));
        }
        return result;
    }

    @Override
    public ActiveEvaluatorGenerator copyOf() {
        return new ActiveEvaluatorGenerator(this);
    }

    public static class InnerKey {
        private final ValuesPredicate predicate;
        private final double complexity;
        private final LhsField.Array<String, ActiveField> fields;

        private InnerKey(ValuesPredicate predicate, double complexity, LhsField.Array<String, ActiveField> fields) {
            this.predicate = predicate;
            this.complexity = complexity;
            this.fields = fields;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InnerKey key = (InnerKey)o;
            return Objects.equals(this.predicate, key.predicate);
        }

        public int hashCode() {
            return Objects.hashCode(this.predicate);
        }
    }
}

