/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.evrete.api.Copyable;
import org.evrete.api.Named;
import org.evrete.api.Type;
import org.evrete.api.TypeField;
import org.evrete.collections.ForkingArrayMap;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.AlphaAddress;
import org.evrete.runtime.FactFieldValues;
import org.evrete.runtime.TypeAlphaConditions;
import org.evrete.runtime.evaluation.AlphaConditionHandle;
import org.evrete.runtime.evaluation.DefaultEvaluatorHandle;
import org.evrete.util.AbstractIndex;

public class ActiveType
implements Copyable<ActiveType> {
    private final ActiveFields activeFields;
    private final AlphaConditionIndexer alphaConditionIndexer;
    private final AlphaConditionSubsetIndexer alphaConditionSubsetIndexer;
    private final Type<?> value;
    private final Idx id;
    private final Set<AlphaAddress> knownAlphaLocations;

    public ActiveType(Idx id, Type<?> value) {
        this.value = value;
        this.id = id;
        this.activeFields = new ActiveFields(id);
        this.alphaConditionIndexer = new AlphaConditionIndexer();
        this.alphaConditionSubsetIndexer = new AlphaConditionSubsetIndexer(id);
        this.knownAlphaLocations = new HashSet<AlphaAddress>();
    }

    public Type<?> getValue() {
        return this.value;
    }

    public Idx getId() {
        return this.id;
    }

    private ActiveType(ActiveType parent) {
        this.value = (Type)parent.value.copyOf();
        this.id = parent.id;
        this.activeFields = parent.activeFields.copyOf();
        this.alphaConditionIndexer = parent.alphaConditionIndexer.copyOf();
        this.alphaConditionSubsetIndexer = parent.alphaConditionSubsetIndexer.copyOf();
        this.knownAlphaLocations = new HashSet<AlphaAddress>(parent.knownAlphaLocations);
    }

    void registerAlphaAddress(AlphaAddress alphaAddress) {
        this.knownAlphaLocations.add(alphaAddress);
    }

    public Set<AlphaAddress> getKnownAlphaLocations() {
        return Collections.unmodifiableSet(this.knownAlphaLocations);
    }

    public Stream<AlphaConditionHandle> getAlphaConditions() {
        return this.alphaConditionIndexer.values();
    }

    TypeAlphaConditions getCreateAlphaConditions(Set<DefaultEvaluatorHandle> alphaConditions) {
        HashSet<AlphaConditionHandle> indexedAlphaConditions = new HashSet<AlphaConditionHandle>(alphaConditions.size());
        for (DefaultEvaluatorHandle alphaCondition : alphaConditions) {
            Map.Entry entry = this.alphaConditionIndexer.getOrCreateEntry(alphaCondition);
            indexedAlphaConditions.add((AlphaConditionHandle)entry.getValue());
        }
        return (TypeAlphaConditions)this.alphaConditionSubsetIndexer.getOrCreateEntry(indexedAlphaConditions).getValue();
    }

    FactFieldValues readFactValue(Type<?> type, Object fact) {
        Object[] values = new Object[this.activeFields.size()];
        this.activeFields.forEachValue(activeField -> {
            TypeField field = type.getField(activeField.getName());
            values[activeField.valueIndex()] = field.readValue(fact);
        });
        return new FactFieldValues(values);
    }

    ActiveField getCreateActiveField(TypeField field) {
        return (ActiveField)this.activeFields.getOrCreateEntry(field).getValue();
    }

    int getCountOfAlphaConditions() {
        return this.alphaConditionIndexer.size();
    }

    int getFieldCount() {
        return this.activeFields.size();
    }

    void forEachAlphaCondition(Consumer<AlphaConditionHandle> action) {
        this.alphaConditionIndexer.forEachValue(action);
    }

    void forEachAlphaAddress(Consumer<AlphaAddress> action) {
        this.knownAlphaLocations.forEach(action);
    }

    @Override
    public ActiveType copyOf() {
        return new ActiveType(this);
    }

    public String toString() {
        return "{id=" + String.valueOf(this.getId()) + ", name='" + this.getValue().getName() + "', fieldCount=" + this.activeFields.size() + "}";
    }

    public static class Idx
    extends AbstractIndex
    implements Serializable {
        private static final long serialVersionUID = 6171956208382559856L;

        public Idx(int index) {
            super(index, index);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Idx that = (Idx)o;
            return this.getIndex() == that.getIndex();
        }
    }

    private static class ActiveFields
    extends ForkingArrayMap<TypeField, String, ActiveField.Index, ActiveField>
    implements Copyable<ActiveFields> {
        final Idx typeId;

        ActiveFields(Idx typeId) {
            super(Named::getName);
            this.typeId = typeId;
        }

        ActiveFields(ActiveFields parent) {
            super(parent);
            this.typeId = parent.typeId;
        }

        @Override
        protected ActiveField.Index generateKey(TypeField value, int index) {
            return new ActiveField.Index(index);
        }

        @Override
        protected ActiveField generateValue(ActiveField.Index index, TypeField value) {
            return new ActiveField(this.typeId, value, index.getIndex());
        }

        @Override
        public ActiveFields copyOf() {
            return new ActiveFields(this);
        }
    }

    private static class AlphaConditionIndexer
    extends ForkingArrayMap<DefaultEvaluatorHandle, Integer, AlphaConditionHandle, AlphaConditionHandle>
    implements Copyable<AlphaConditionIndexer> {
        AlphaConditionIndexer() {
            super(DefaultEvaluatorHandle::getIndex);
        }

        AlphaConditionIndexer(AlphaConditionIndexer other) {
            super(other);
        }

        @Override
        protected AlphaConditionHandle generateKey(DefaultEvaluatorHandle value, int index) {
            return new AlphaConditionHandle(index, value);
        }

        @Override
        protected AlphaConditionHandle generateValue(AlphaConditionHandle idx, DefaultEvaluatorHandle value) {
            return idx;
        }

        @Override
        public AlphaConditionIndexer copyOf() {
            return new AlphaConditionIndexer(this);
        }
    }

    private static class AlphaConditionSubsetIndexer
    extends ForkingArrayMap<Set<AlphaConditionHandle>, Set<AlphaConditionHandle>, TypeAlphaConditions, TypeAlphaConditions>
    implements Copyable<AlphaConditionSubsetIndexer> {
        private final Idx type;

        public AlphaConditionSubsetIndexer(Idx type) {
            super((T set) -> set);
            this.type = type;
        }

        public AlphaConditionSubsetIndexer(AlphaConditionSubsetIndexer other, Idx type) {
            super(other);
            this.type = type;
        }

        @Override
        protected TypeAlphaConditions generateKey(Set<AlphaConditionHandle> value, int index) {
            return new TypeAlphaConditions(index, this.type, value);
        }

        @Override
        protected TypeAlphaConditions generateValue(TypeAlphaConditions idx, Set<AlphaConditionHandle> value) {
            return idx;
        }

        @Override
        public AlphaConditionSubsetIndexer copyOf() {
            return new AlphaConditionSubsetIndexer(this, this.type);
        }
    }
}

