/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.evrete.api.EvaluatorHandle;
import org.evrete.api.LhsField;
import org.evrete.api.LiteralPredicate;
import org.evrete.api.NamedType;
import org.evrete.api.TypeField;
import org.evrete.api.ValuesPredicate;
import org.evrete.api.builders.ConditionManager;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.LhsConditionDH;
import org.evrete.runtime.RuntimeAware;
import org.evrete.runtime.evaluation.DefaultEvaluatorHandle;
import org.evrete.runtime.evaluation.ValuePredicateOfArray;

class DefaultConditionManager
extends RuntimeAware
implements ConditionManager {
    private final Collection<Literal> literals = new LinkedList<Literal>();
    private final Collection<LhsConditionDH<String, ActiveField>> evaluators = new LinkedList<LhsConditionDH<String, ActiveField>>();
    private final NamedType.Resolver namedTypeResolver;

    DefaultConditionManager(AbstractRuntime<?, ?> runtime, NamedType.Resolver namedTypeResolver) {
        super(runtime);
        this.namedTypeResolver = namedTypeResolver;
    }

    void addLhsBuilderCondition(String expression, double complexity) {
        this.addCondition(expression, complexity);
    }

    void addLhsBuilderCondition(ValuesPredicate predicate, double complexity, String[] references) {
        this.addCondition(predicate, complexity, references);
    }

    void addLhsBuilderCondition(Predicate<Object[]> predicate, double complexity, String[] references) {
        this.addCondition(predicate, complexity, references);
    }

    Collection<Literal> getLiterals() {
        return this.literals;
    }

    Collection<LhsConditionDH<String, ActiveField>> getEvaluators() {
        return this.evaluators;
    }

    @Override
    public EvaluatorHandle addCondition(ValuesPredicate predicate, double complexity, String ... references) {
        LhsField.Array<String, TypeField> stringFields = LhsField.Array.toFields(references, this.namedTypeResolver);
        LhsField.Array<String, ActiveField> activeFields = this.runtime.toActiveFields(stringFields);
        DefaultEvaluatorHandle handle = this.runtime.getEvaluatorsContext().addEvaluator(predicate, complexity, activeFields);
        this.evaluators.add(new LhsConditionDH<String, ActiveField>(handle, activeFields));
        return handle;
    }

    @Override
    public EvaluatorHandle addCondition(Predicate<Object[]> predicate, double complexity, String ... references) {
        return this.addCondition((ValuesPredicate)new ValuePredicateOfArray(predicate, references.length), complexity, references);
    }

    @Override
    public CompletableFuture<EvaluatorHandle> addCondition(String expression, double complexity) {
        if (expression == null || expression.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        Literal condition = new Literal(expression, complexity);
        this.literals.add(condition);
        return condition.getHandle().thenApply(handle -> handle);
    }

    static class Literal
    implements LiteralPredicate {
        private final String expression;
        private final double complexity;
        private final CompletableFuture<DefaultEvaluatorHandle> handle;

        public Literal(String expression, double complexity) {
            this.expression = expression;
            this.complexity = complexity;
            this.handle = new CompletableFuture();
        }

        @Override
        public String getSource() {
            return this.expression;
        }

        @Override
        public double getComplexity() {
            return this.complexity;
        }

        public CompletableFuture<DefaultEvaluatorHandle> getHandle() {
            return this.handle;
        }

        public String toString() {
            if (this.complexity == 1.0) {
                return "'" + this.expression + "'";
            }
            return "{'" + this.expression + "', complexity=" + this.complexity + "}";
        }
    }
}

