/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.List;
import org.evrete.api.RuntimeContext;
import org.evrete.api.builders.RuleBuilder;
import org.evrete.api.builders.RuleSetBuilder;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.DefaultRuleBuilder;
import org.evrete.util.AbstractEnvironment;

class DefaultRuleSetBuilder<C extends RuntimeContext<C>>
extends AbstractEnvironment
implements RuleSetBuilder<C> {
    private final AbstractRuntime<?, C> runtime;
    private final List<DefaultRuleBuilder<C>> ruleBuilders = new ArrayList<DefaultRuleBuilder<C>>();
    private boolean open = true;
    private final ClassLoader classLoader;

    DefaultRuleSetBuilder(AbstractRuntime<?, C> runtime, ClassLoader classLoader) {
        super(runtime);
        this.runtime = runtime;
        this.classLoader = classLoader;
    }

    @Override
    public DefaultRuleBuilder<C> newRule(String name) {
        this.assertOpen();
        DefaultRuleBuilder ruleBuilder = new DefaultRuleBuilder(this, name);
        this.ruleBuilders.add(ruleBuilder);
        return ruleBuilder;
    }

    @Override
    public RuleSetBuilder<C> set(String property, Object value) {
        this.assertOpen();
        super.set(property, value);
        return this;
    }

    @Override
    public final RuleBuilder<C> newRule() {
        return this.newRule(this.runtime.unnamedRuleName());
    }

    @Override
    public C build() {
        this.assertOpen();
        this.runtime.addRules(this);
        this.open = false;
        return this.getContext();
    }

    private void assertOpen() {
        if (!this.open) {
            throw new IllegalStateException("This ruleset has not been built.");
        }
    }

    @Override
    public C getContext() {
        return (C)this.runtime;
    }

    List<DefaultRuleBuilder<C>> getRuleBuilders() {
        return this.ruleBuilders;
    }

    AbstractRuntime<?, C> getRuntime() {
        return this.runtime;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

