/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.BitSet;
import java.util.Collection;
import java.util.Objects;
import java.util.function.ToIntFunction;
import org.evrete.runtime.AbstractLhsFact;
import org.evrete.runtime.ActiveType;
import org.evrete.runtime.AlphaAddress;
import org.evrete.runtime.FactType;
import org.evrete.runtime.evaluation.AlphaConditionHandle;
import org.evrete.util.IndexedValue;

public final class Mask<T> {
    private final BitSet delegate = new BitSet();
    private final ToIntFunction<T> intMapper;

    private Mask(ToIntFunction<T> intMapper) {
        this.intMapper = intMapper;
    }

    BitSet getDelegate() {
        return this.delegate;
    }

    public void or(Mask<T> other) {
        this.delegate.or(other.delegate);
    }

    public boolean containsAll(Mask<T> value) {
        BitSet other = value.delegate;
        if (other.isEmpty() && this.delegate.isEmpty()) {
            return true;
        }
        BitSet otherCloned = (BitSet)other.clone();
        otherCloned.and(this.delegate);
        return otherCloned.equals(other);
    }

    public Mask<T> set(T obj) {
        this.delegate.set(this.intMapper.applyAsInt(obj));
        return this;
    }

    public Mask<T> set(T obj, boolean flag) {
        this.delegate.set(this.intMapper.applyAsInt(obj), flag);
        return this;
    }

    public Mask<T> set(T[] arr) {
        for (T obj : arr) {
            this.set(obj);
        }
        return this;
    }

    public Mask<T> set(Collection<? extends T> arr) {
        for (T obj : arr) {
            this.set(obj);
        }
        return this;
    }

    public boolean get(T obj) {
        return this.delegate.get(this.intMapper.applyAsInt(obj));
    }

    public int cardinality() {
        return this.delegate.cardinality();
    }

    public int length() {
        return this.delegate.length();
    }

    public boolean intersects(Mask<T> other) {
        return this.delegate.intersects(other.delegate);
    }

    public static <I extends IndexedValue<?>> Mask<I> ofIndexed() {
        return new Mask<IndexedValue>(value -> value.getIndex());
    }

    public static <I> Mask<I> instance(ToIntFunction<I> intMapper) {
        return new Mask<I>(intMapper);
    }

    public static <I extends IndexedValue<?>> Mask<I> or(Collection<Mask<I>> collection) {
        Mask<I> result = Mask.ofIndexed();
        for (Mask<I> mask : collection) {
            result.or(mask);
        }
        return result;
    }

    public static Mask<FactType> factTypeMask() {
        return new Mask<FactType>(AbstractLhsFact::getInRuleIndex);
    }

    public static Mask<AlphaConditionHandle> alphaConditionsMask() {
        return Mask.instance(AlphaConditionHandle::getIndex);
    }

    public static Mask<ActiveType> typeMask() {
        return new Mask<ActiveType>(value -> value.getId().getIndex());
    }

    public static Mask<AlphaAddress> alphaAddressMask() {
        return Mask.instance(AlphaAddress::getIndex);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mask mask = (Mask)o;
        return Objects.equals(this.delegate, mask.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

