/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Iterator;
import java.util.Objects;
import java.util.logging.Logger;
import org.evrete.api.spi.MemoryScope;
import org.evrete.runtime.DefaultFactHandle;
import org.evrete.runtime.FactHolder;
import org.evrete.runtime.FactType;
import org.evrete.runtime.SessionMemory;
import org.evrete.runtime.TypeAlphaMemory;
import org.evrete.runtime.rete.ConditionMemory;
import org.evrete.util.FlatMapIterator;

class SessionFactType
extends FactType {
    private static final Logger LOGGER = Logger.getLogger(SessionFactType.class.getName());
    private final SessionMemory memory;

    SessionFactType(FactType factType, SessionMemory memory) {
        super(factType);
        this.memory = memory;
    }

    FactHolder getFact(DefaultFactHandle handle) {
        return Objects.requireNonNull((FactHolder)this.memory.getTypeMemory(handle).get(handle), () -> "No fact found for " + String.valueOf(handle) + " at " + String.valueOf(this));
    }

    private TypeAlphaMemory alphaMemory() {
        return this.memory.getAlphaMemory(this.getAlphaAddress());
    }

    Iterator<Long> keyIterator(MemoryScope scope) {
        LOGGER.finer(() -> "Requested " + String.valueOf((Object)scope) + " key iterator for fact type '" + this.getVarName() + "', alpha address: " + String.valueOf(this.getAlphaAddress()) + ", has data: " + this.alphaMemory().keyIterator(scope).hasNext());
        return this.alphaMemory().keyIterator(scope);
    }

    Iterator<DefaultFactHandle> factIterator(MemoryScope scope) {
        return new FlatMapIterator(this.keyIterator(scope), values -> this.alphaMemory().valueIterator(scope, (long)values));
    }

    Iterator<DefaultFactHandle> factIterator(ConditionMemory.ScopedValueId key) {
        return this.alphaMemory().valueIterator(key.getScope(), key.getValueId());
    }

    @Override
    public String toString() {
        return "{var='" + this.getVarName() + "', type=" + String.valueOf(this.type().getId()) + ", alphaAddress=" + String.valueOf(this.getAlphaAddress()) + "}";
    }
}

