/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.compiler;

import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.evrete.Configuration;
import org.evrete.api.CompiledPredicate;
import org.evrete.api.Imports;
import org.evrete.api.IntToValue;
import org.evrete.api.LhsField;
import org.evrete.api.LiteralPredicate;
import org.evrete.api.NamedType;
import org.evrete.api.RhsContext;
import org.evrete.api.Rule;
import org.evrete.api.RuleCompiledSources;
import org.evrete.api.RuleLiteralData;
import org.evrete.api.RuntimeContext;
import org.evrete.api.TypeField;
import org.evrete.api.ValuesPredicate;
import org.evrete.api.spi.SourceCompiler;
import org.evrete.runtime.compiler.ConditionStringTerm;
import org.evrete.runtime.compiler.StringLiteralEncoder;
import org.evrete.spi.minimal.AbstractLiteralRhs;
import org.evrete.util.BaseRuleClass;
import org.evrete.util.CommonUtils;
import org.evrete.util.CompilationException;

public class DefaultLiteralSourceCompiler {
    private static final String TAB = "  ";
    private static final String RHS_CLASS_NAME = "Rhs";
    private static final String RHS_INSTANCE_VAR = "ACTION";
    private static final AtomicLong classCounter = new AtomicLong();
    static final String CLASS_PACKAGE = DefaultLiteralSourceCompiler.class.getPackage().getName() + ".compiled";

    public <S extends RuleLiteralData<R, C>, R extends Rule, C extends LiteralPredicate> Collection<RuleCompiledSources<S, R, C>> compile(RuntimeContext<?> context, ClassLoader classLoader, Collection<S> sources) throws CompilationException {
        if (sources.isEmpty()) {
            return Collections.emptyList();
        }
        Configuration configuration = context.getConfiguration();
        boolean compilationDisabled = configuration.getAsBoolean("evrete.core.disable-literal-data", false);
        if (compilationDisabled) {
            throw new IllegalStateException("Literal conditions and actions were explicitly disabled in the configuration");
        }
        String stripFlag = configuration.getProperty("evrete.spi.compiler.lhs-strip-whitespaces");
        if (stripFlag == null) {
            try {
                return this.compile(context, classLoader, sources, true);
            }
            catch (CompilationException e) {
                return this.compile(context, classLoader, sources, false);
            }
        }
        return this.compile(context, classLoader, sources, Boolean.parseBoolean(stripFlag));
    }

    private <S extends RuleLiteralData<R, C>, R extends Rule, C extends LiteralPredicate> Collection<RuleCompiledSources<S, R, C>> compile(RuntimeContext<?> context, ClassLoader classLoader, Collection<S> sources, boolean stripWhitespaces) throws CompilationException {
        SourceCompiler compiler = context.getService().getSourceCompilerProvider().instance(classLoader);
        Collection javaSources = sources.stream().map(o -> new RuleSource((RuleLiteralData)o, context, stripWhitespaces)).collect(Collectors.toList());
        Collection result = compiler.compile(javaSources);
        return result.stream().map(compiledSource -> {
            Class<?> ruleClass = compiledSource.getCompiledClass();
            return new RuleCompiledSourcesImpl(ruleClass, (RuleSource)compiledSource.getSource(), ((RuleSource)compiledSource.getSource()).javaSource);
        }).collect(Collectors.toList());
    }

    public static class RuleCompiledSourcesImpl<S extends RuleLiteralData<R, C>, R extends Rule, C extends LiteralPredicate>
    implements RuleCompiledSources<S, R, C> {
        private final RuleSource<S, R, C> source;
        private final Collection<CompiledPredicate<C>> conditions;
        private final Consumer<RhsContext> rhs;
        private final String classJavaSource;

        public RuleCompiledSourcesImpl(Class<?> ruleClass, RuleSource<S, R, C> source, String classJavaSource) {
            this.source = source;
            this.classJavaSource = classJavaSource;
            IdentityHashMap compiledConditions = new IdentityHashMap();
            for (ConditionSource conditionSource : source.conditionSources) {
                compiledConditions.put(conditionSource.source, conditionSource);
            }
            Collection originalConditions = source.delegate.conditions();
            this.conditions = new ArrayList<CompiledPredicate<C>>(originalConditions.size());
            for (LiteralPredicate condition : originalConditions) {
                ConditionSource compiled = (ConditionSource)compiledConditions.get(condition);
                if (compiled == null) {
                    throw new IllegalStateException("Condition not found or not compiled");
                }
                assert (compiled.source.equals(condition));
                this.conditions.add(new CompiledPredicateImpl(compiled, ruleClass));
            }
            this.rhs = source.delegate.rhs() == null ? null : RuleCompiledSourcesImpl.fromClass(ruleClass);
        }

        private static Consumer<RhsContext> fromClass(Class<?> ruleClass) {
            try {
                return (Consumer)ruleClass.getDeclaredField(DefaultLiteralSourceCompiler.RHS_INSTANCE_VAR).get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalStateException("RHS source provided but not compiled");
            }
        }

        public String getClassJavaSource() {
            return this.classJavaSource;
        }

        @Override
        public S getSources() {
            return this.source.delegate;
        }

        @Override
        public Collection<CompiledPredicate<C>> conditions() {
            return this.conditions;
        }

        @Override
        public Consumer<RhsContext> rhs() {
            return this.rhs;
        }
    }

    public static class RuleSource<S extends RuleLiteralData<R, C>, R extends Rule, C extends LiteralPredicate>
    implements SourceCompiler.ClassSource {
        private final String className;
        private final String classSimpleName;
        private final S delegate;
        private final Imports imports;
        private final RhsSource rhsSource;
        private final String javaSource;
        private final Collection<ConditionSource<C>> conditionSources;

        RuleSource(S delegate, RuntimeContext<?> context, boolean stripWhitespaces) {
            this.delegate = delegate;
            this.imports = context.getImports();
            this.classSimpleName = "Rule" + classCounter.incrementAndGet();
            this.className = CLASS_PACKAGE + "." + this.classSimpleName;
            AtomicInteger conditionCounter = new AtomicInteger();
            this.conditionSources = delegate.conditions().stream().map(s -> new ConditionSource<LiteralPredicate>((Rule)delegate.getRule(), "condition" + conditionCounter.incrementAndGet(), this.classSimpleName, (LiteralPredicate)s, stripWhitespaces)).collect(Collectors.toList());
            String rhs = delegate.rhs();
            this.rhsSource = rhs == null ? null : new RhsSource((Rule)delegate.getRule(), rhs);
            this.javaSource = this.buildSource();
        }

        private String buildSource() {
            StringBuilder sb = new StringBuilder(4096);
            this.appendHeader(sb);
            if (this.rhsSource != null) {
                this.rhsSource.appendClassVar(sb);
            }
            for (ConditionSource<C> source : this.conditionSources) {
                sb.append(DefaultLiteralSourceCompiler.TAB);
                source.appendDeclaration(sb);
            }
            if (!this.conditionSources.isEmpty()) {
                sb.append("\n").append(DefaultLiteralSourceCompiler.TAB).append("static {\n");
                sb.append(DefaultLiteralSourceCompiler.TAB).append(DefaultLiteralSourceCompiler.TAB).append("try {\n");
                for (ConditionSource<C> source : this.conditionSources) {
                    sb.append(DefaultLiteralSourceCompiler.TAB);
                    sb.append(DefaultLiteralSourceCompiler.TAB);
                    sb.append(DefaultLiteralSourceCompiler.TAB);
                    source.appendDefinition(sb);
                }
                sb.append(DefaultLiteralSourceCompiler.TAB).append(DefaultLiteralSourceCompiler.TAB).append("} catch (Exception e) {\n");
                sb.append(DefaultLiteralSourceCompiler.TAB).append(DefaultLiteralSourceCompiler.TAB).append(DefaultLiteralSourceCompiler.TAB).append("throw new IllegalStateException(e);\n");
                sb.append(DefaultLiteralSourceCompiler.TAB).append(DefaultLiteralSourceCompiler.TAB).append("}\n");
                sb.append(DefaultLiteralSourceCompiler.TAB).append("}\n");
            }
            for (ConditionSource<C> source : this.conditionSources) {
                source.appendHandleMethod(sb);
                source.appendInnerMethod(sb);
                sb.append("\n");
            }
            if (this.rhsSource != null) {
                this.rhsSource.appendClassBody(sb);
            }
            this.appendFooter(sb);
            return sb.toString();
        }

        @Override
        public String binaryName() {
            return this.className;
        }

        @Override
        public String getSource() {
            return this.javaSource;
        }

        private void appendHeader(StringBuilder target) {
            target.append("package ").append(CLASS_PACKAGE).append(";\n\n");
            this.imports.asJavaImportStatements(target);
            String baseClassName = this.delegate.getRule().get("evrete.impl.rule-base-class", (String)BaseRuleClass.class.getCanonicalName());
            target.append("public final class ").append(this.classSimpleName).append(" extends ").append(baseClassName).append(" {\n");
        }

        private void appendFooter(StringBuilder target) {
            target.append("\n}\n");
        }
    }

    private static class CompiledPredicateImpl<C extends LiteralPredicate>
    implements CompiledPredicate<C> {
        private final ConditionSource<C> compiled;
        private final PredicateImpl<C> delegate;

        public CompiledPredicateImpl(ConditionSource<C> compiled, Class<?> ruleClass) {
            this.compiled = compiled;
            Object source = compiled.source;
            this.delegate = new PredicateImpl(CompiledPredicateImpl.getHandle(ruleClass, compiled.handleName), compiled.resolvedFields, source);
        }

        @Override
        public LhsField.Array<String, TypeField> resolvedFields() {
            return this.compiled.resolvedFields;
        }

        @Override
        public ValuesPredicate getPredicate() {
            return this.delegate;
        }

        @Override
        public C getSource() {
            return this.compiled.source;
        }

        public String toString() {
            return this.getSource().toString();
        }

        static MethodHandle getHandle(Class<?> compiledClass, String name) {
            try {
                return (MethodHandle)compiledClass.getDeclaredField(name).get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalStateException("Handle not found", e);
            }
        }

        static class PredicateImpl<C extends LiteralPredicate>
        implements ValuesPredicate {
            private final MethodHandle handle;
            private final LhsField.Array<String, TypeField> resolvedFields;
            private final C source;

            PredicateImpl(MethodHandle handle, LhsField.Array<String, TypeField> resolvedFields, C source) {
                this.handle = handle;
                this.resolvedFields = resolvedFields;
                this.source = source;
            }

            private static boolean sameCondition(PredicateImpl<?> p1, PredicateImpl<?> p2) {
                if (Objects.equals(p1.source.getSource(), p2.source.getSource())) {
                    if (p1.resolvedFields.length() == p2.resolvedFields.length()) {
                        for (int i = 0; i < p1.resolvedFields.length(); ++i) {
                            TypeField f1 = p1.resolvedFields.get(i).field();
                            TypeField f2 = p2.resolvedFields.get(i).field();
                            String name1 = f1.getName();
                            String name2 = f2.getName();
                            Class<?> valueType1 = f1.getValueType();
                            Class<?> valueType2 = f2.getValueType();
                            Class<?> declaringType1 = f1.getDeclaringType().getJavaClass();
                            Class<?> declaringType2 = f2.getDeclaringType().getJavaClass();
                            if (!Objects.equals(name1, name2)) {
                                return false;
                            }
                            if (!Objects.equals(valueType1, valueType2)) {
                                return false;
                            }
                            if (Objects.equals(declaringType1, declaringType2)) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
                return false;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                PredicateImpl predicate = (PredicateImpl)o;
                return PredicateImpl.sameCondition(this, predicate);
            }

            public int hashCode() {
                return this.source.getSource().hashCode();
            }

            public String toString() {
                return this.source.toString();
            }

            @Override
            public boolean test(IntToValue values) {
                try {
                    return this.handle.invokeExact(values);
                }
                catch (Throwable t) {
                    Object[] args = new Object[this.resolvedFields.length()];
                    for (int i = 0; i < args.length; ++i) {
                        args[i] = values.apply(i);
                    }
                    throw new IllegalStateException("Evaluation exception at " + String.valueOf(this.source) + ", fields: " + String.valueOf(this.resolvedFields) + ", post-exception values:" + Arrays.toString(args), t);
                }
            }
        }
    }

    private static class RhsSource {
        final String rhs;
        final Rule rule;
        final StringJoiner methodArgs;
        final StringJoiner args;

        RhsSource(Rule rule, String rhs) {
            this.rule = rule;
            this.rhs = rhs;
            this.methodArgs = new StringJoiner(", ");
            this.args = new StringJoiner(", ");
            for (NamedType t : rule.getDeclaredFactTypes()) {
                this.methodArgs.add(t.getType().getJavaClass().getCanonicalName() + " " + t.getVarName());
                this.args.add(t.getVarName());
            }
        }

        void appendClassVar(StringBuilder target) {
            target.append(DefaultLiteralSourceCompiler.TAB).append("public static final Rhs ").append("ACTION = new Rhs();").append("\n");
        }

        void appendClassBody(StringBuilder target) {
            String[] lines;
            target.append("\n").append(DefaultLiteralSourceCompiler.TAB).append("public static class Rhs extends ").append(AbstractLiteralRhs.class.getName()).append(" {\n\n").append(DefaultLiteralSourceCompiler.TAB).append(DefaultLiteralSourceCompiler.TAB).append("@Override\n").append(DefaultLiteralSourceCompiler.TAB).append(DefaultLiteralSourceCompiler.TAB).append("protected final void doRhs() {\n");
            for (NamedType t : this.rule.getDeclaredFactTypes()) {
                target.append(DefaultLiteralSourceCompiler.TAB).append(DefaultLiteralSourceCompiler.TAB).append(DefaultLiteralSourceCompiler.TAB).append(t.getType().getJavaClass().getCanonicalName()).append(" ").append(t.getVarName()).append(" = ").append("get(\"").append(t.getVarName()).append("\");\n");
            }
            target.append(DefaultLiteralSourceCompiler.TAB).append(DefaultLiteralSourceCompiler.TAB).append(DefaultLiteralSourceCompiler.TAB).append("this.doRhs(").append(this.args).append(");\n").append(DefaultLiteralSourceCompiler.TAB).append(DefaultLiteralSourceCompiler.TAB).append("}\n\n");
            target.append(DefaultLiteralSourceCompiler.TAB).append(DefaultLiteralSourceCompiler.TAB).append("private void doRhs(").append(this.methodArgs).append(") {\n");
            String source = "/***** Start RHS source *****/\n" + this.rhs + "\n/****** End RHS source ******/";
            for (String line : lines = source.split("\n")) {
                target.append(DefaultLiteralSourceCompiler.TAB).append(DefaultLiteralSourceCompiler.TAB).append(DefaultLiteralSourceCompiler.TAB).append(line).append("\n");
            }
            target.append(DefaultLiteralSourceCompiler.TAB).append(DefaultLiteralSourceCompiler.TAB).append("}\n").append(DefaultLiteralSourceCompiler.TAB).append("}");
        }
    }

    private static class ConditionSource<C extends LiteralPredicate> {
        private static final String DECLARATION_TEMPLATE = "public static final java.lang.invoke.MethodHandle %s;\n";
        private static final String DEFINITION_TEMPLATE = "%s = java.lang.invoke.MethodHandles.lookup().findStatic(%s.class, \"%s\", java.lang.invoke.MethodType.methodType(boolean.class, %s));\n";
        private static final String INNER_METHOD_TEMPLATE = "\n  private static boolean %sInner(%s) {\n    return %s;\n  }\n";
        private static final String HANDLE_METHOD_TEMPLATE = "\n  public static boolean %s(%s) {\n    return %sInner(%s);\n  }\n";
        final C source;
        final String methodName;
        final String handleName;
        final String className;
        private final String replaced;
        private final StringJoiner methodArgs;
        private final StringJoiner argCasts;
        private final LhsField.Array<String, TypeField> resolvedFields;

        public ConditionSource(Rule rule, String name, String className, C source, boolean stripWhitespaces) {
            this.className = className;
            this.source = source;
            this.methodName = name;
            this.handleName = name.toUpperCase() + "_HANDLE";
            StringLiteralEncoder encoder = StringLiteralEncoder.of(source.getSource(), stripWhitespaces);
            List<ConditionStringTerm> terms = ConditionStringTerm.resolveTerms(encoder.getEncoded());
            ArrayList<LhsField<String, String>> uniqueReferences = new ArrayList<LhsField<String, String>>();
            ArrayList descriptorBuilder = new ArrayList();
            Object encodedExpression = encoder.getEncoded().value;
            int accumulatedShift = 0;
            int castVarIndex = 0;
            this.argCasts = new StringJoiner(", ");
            this.methodArgs = new StringJoiner(", ");
            for (ConditionStringTerm term : terms) {
                String original = ((String)encodedExpression).substring(term.start + accumulatedShift, term.end + accumulatedShift);
                String javaArgVar = term.varName;
                String before = ((String)encodedExpression).substring(0, term.start + accumulatedShift);
                String after = ((String)encodedExpression).substring(term.end + accumulatedShift);
                encodedExpression = before + javaArgVar + after;
                accumulatedShift += javaArgVar.length() - original.length();
                LhsField<String, String> ref = term.ref;
                if (uniqueReferences.contains(ref)) continue;
                LhsField<String, TypeField> resolvedField = CommonUtils.toTypeField(ref, rule);
                String canonicalFieldType = resolvedField.field().getValueType().getCanonicalName();
                descriptorBuilder.add(resolvedField);
                this.argCasts.add("(" + canonicalFieldType + ") values.apply(" + castVarIndex + ")");
                this.methodArgs.add(canonicalFieldType + " " + javaArgVar);
                ++castVarIndex;
                uniqueReferences.add(ref);
            }
            this.replaced = encoder.unwrapLiterals((String)encodedExpression);
            this.resolvedFields = new LhsField.Array(descriptorBuilder);
        }

        void appendDeclaration(StringBuilder target) {
            target.append(String.format(DECLARATION_TEMPLATE, this.handleName));
        }

        void appendHandleMethod(StringBuilder target) {
            target.append(String.format(HANDLE_METHOD_TEMPLATE, this.methodName, IntToValue.class.getName() + " values", this.methodName, this.argCasts));
        }

        void appendInnerMethod(StringBuilder target) {
            target.append(String.format(INNER_METHOD_TEMPLATE, this.methodName, this.methodArgs, this.replaced));
        }

        void appendDefinition(StringBuilder target) {
            target.append(String.format(DEFINITION_TEMPLATE, this.handleName, this.className, this.methodName, IntToValue.class.getName() + ".class"));
        }
    }
}

