/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.rete;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntFunction;
import java.util.function.ObjIntConsumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.evrete.api.IntToValue;
import org.evrete.api.spi.MemoryScope;
import org.evrete.runtime.AbstractRuleSessionBase;
import org.evrete.runtime.ActiveType;
import org.evrete.runtime.DeltaMemoryMode;
import org.evrete.runtime.FactFieldValues;
import org.evrete.runtime.FactHolder;
import org.evrete.runtime.FactType;
import org.evrete.runtime.MapOfSet;
import org.evrete.runtime.StoredCondition;
import org.evrete.runtime.TypeMemory;
import org.evrete.runtime.evaluation.DefaultEvaluatorHandle;
import org.evrete.runtime.rete.ConditionMemory;
import org.evrete.runtime.rete.ReteKnowledgeConditionNode;
import org.evrete.runtime.rete.ReteKnowledgeEvaluator;
import org.evrete.runtime.rete.ReteSessionNode;
import org.evrete.util.CombinationIterator;
import org.evrete.util.CommonUtils;
import org.evrete.util.FlatMapIterator;
import org.evrete.util.MappingIterator;

public class ReteSessionConditionNode
extends ReteSessionNode {
    private static final Logger LOGGER = Logger.getLogger(ReteSessionConditionNode.class.getName());
    private final ConditionMemory.MemoryEntry[] currentMemoryEntries;
    private final FieldValuesMeta[] currentFieldValues;
    private final ResolvedEvaluator evaluator;
    private final ConditionMemory betaMemory;
    private final TypeMemory[] nodeTypeMemories;

    public ReteSessionConditionNode(AbstractRuleSessionBase<?> session, ReteSessionNode[] sourceNodes, ReteKnowledgeConditionNode knowledgeConditionNode) {
        super(session, knowledgeConditionNode, sourceNodes);
        int totalSources = sourceNodes.length;
        this.currentMemoryEntries = new ConditionMemory.MemoryEntry[totalSources];
        FactType[] nodeFactTypes = this.getNodeFactTypes();
        this.currentFieldValues = new FieldValuesMeta[nodeFactTypes.length];
        this.nodeTypeMemories = new TypeMemory[nodeFactTypes.length];
        for (int i = 0; i < nodeFactTypes.length; ++i) {
            this.nodeTypeMemories[i] = session.getMemory().getTypeMemory(nodeFactTypes[i]);
        }
        this.betaMemory = new ConditionMemory();
        this.evaluator = new ResolvedEvaluator(session, knowledgeConditionNode.getEvaluator());
    }

    @Override
    String debugName() {
        return FactType.toSimpleDebugString((FactType[])this.getNodeFactTypes());
    }

    @Override
    public CompletableFuture<Void> computeDeltaMemoryAsync(DeltaMemoryMode mode) {
        LOGGER.fine(() -> "Node " + this.debugName() + " is requesting delta memories from sources: " + this.debugName((ReteSessionNode[])this.sourceNodes));
        return CommonUtils.completeAll((ReteSessionNode[])this.sourceNodes, sourceNode -> sourceNode.computeDeltaMemoryAsync(mode)).thenRunAsync(() -> this.computeDeltaLocally(mode), this.getExecutor());
    }

    public ConditionMemory getBetaMemory() {
        return this.betaMemory;
    }

    public void deleteAll(Collection<FactHolder> factHolders) {
        this.betaMemory.deleteAll(ConditionMemory.DeletePredicate.ofMultipleOR(this.createDeletePredicates(factHolders)));
    }

    private Collection<ConditionMemory.DeletePredicate> createDeletePredicates(Collection<FactHolder> factHolders) {
        MapOfSet<Integer, Long> mapping = new MapOfSet<Integer, Long>();
        for (FactHolder factHolder : factHolders) {
            ActiveType.Idx type = factHolder.getHandle().getType();
            Collection<Integer> indicesForType = this.nodeIndices(type);
            for (Integer index : indicesForType) {
                mapping.add(index, factHolder.getFieldValuesId());
            }
        }
        ArrayList<ConditionMemory.DeletePredicate> result = new ArrayList<ConditionMemory.DeletePredicate>(mapping.size());
        for (Map.Entry entry : mapping.entrySet()) {
            result.add(new ConditionMemory.DeletePredicate((Integer)entry.getKey(), (Set)entry.getValue()));
        }
        return result;
    }

    void computeDeltaLocally(DeltaMemoryMode mode) {
        Iterator<MemoryScope[]> sourceScopes;
        MemoryScope saveDestination;
        this.evaluator.refreshConditions();
        if (mode == DeltaMemoryMode.DEFAULT) {
            saveDestination = MemoryScope.DELTA;
            sourceScopes = MemoryScope.states(MemoryScope.DELTA, new MemoryScope[((ReteSessionNode[])this.sourceNodes).length]);
        } else if (mode == DeltaMemoryMode.HOT_DEPLOYMENT) {
            saveDestination = MemoryScope.MAIN;
            sourceScopes = MemoryScope.states(MemoryScope.MAIN, new MemoryScope[((ReteSessionNode[])this.sourceNodes).length]);
        } else {
            throw new IllegalStateException("Unknown memory scope mode: " + String.valueOf((Object)mode));
        }
        this.computeDeltaLocally(saveDestination, sourceScopes);
    }

    void computeDeltaLocally(MemoryScope saveDestination, Iterator<MemoryScope[]> sourceScopes) {
        LOGGER.fine(() -> "Node " + this.debugName() + " starting to compute local delta from sources: " + this.debugName((ReteSessionNode[])this.sourceNodes));
        this.betaMemory.clearDeltaMemory();
        ReteSessionNode[] sourceNodes = (ReteSessionNode[])this.sourceNodes();
        FlatMapIterator sourceCombinations = new FlatMapIterator(sourceScopes, scopes -> new ListeningCombinationIterator(this.currentMemoryEntries, index -> sourceNodes[index].iterator(scopes[index]), this::sourceValueChanged));
        sourceCombinations.forEachRemaining(ignored -> this.evaluateAndSave(saveDestination));
        LOGGER.fine(() -> "Node " + this.debugName() + " has finished computing its delta memory. New delta memory size: " + this.betaMemory.size(MemoryScope.DELTA) + ", main memory size: " + this.betaMemory.size(MemoryScope.MAIN));
    }

    private void evaluateAndSave(MemoryScope saveDestination) {
        if (this.evaluator.test()) {
            ConditionMemory.ScopedValueId[] ids = new ConditionMemory.ScopedValueId[this.currentFieldValues.length];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = new ConditionMemory.ScopedValueId(this.currentFieldValues[i].valuesId, this.currentFieldValues[i].scope);
            }
            ConditionMemory.MemoryEntry entry = new ConditionMemory.MemoryEntry(ids);
            this.betaMemory.saveNewEntry(saveDestination, entry);
            LOGGER.finer(() -> "Node " + this.debugName() + ", new delta entry: " + Arrays.toString(this.currentFieldValues) + ". Delta memory size: " + this.betaMemory.size(MemoryScope.DELTA));
        }
    }

    private void sourceValueChanged(ConditionMemory.MemoryEntry memoryEntry, int sourceIndex) {
        ConditionMemory.ScopedValueId[] valueIds = memoryEntry.getScopedValueIds();
        for (int i = 0; i < valueIds.length; ++i) {
            int pos = this.location(sourceIndex, i);
            long newValuesId = valueIds[i].getValueId();
            MemoryScope newScope = valueIds[i].getScope();
            FieldValuesMeta localVal = this.currentFieldValues[pos];
            if (localVal != null && localVal.valuesId == newValuesId && localVal.scope == newScope) continue;
            FactFieldValues fieldValues = this.nodeTypeMemories[pos].readFieldValues(newValuesId);
            this.currentFieldValues[pos] = new FieldValuesMeta(fieldValues, newValuesId, newScope);
        }
    }

    @Override
    Iterator<ConditionMemory.MemoryEntry> iterator(MemoryScope scope) {
        return this.betaMemory.iterator(scope);
    }

    public Iterator<ConditionMemory.ScopedValueId[]> memoryIterator(MemoryScope scope) {
        return new MappingIterator<ConditionMemory.MemoryEntry, ConditionMemory.ScopedValueId[]>(this.iterator(scope), ConditionMemory.MemoryEntry::scopedValues);
    }

    public void commit() {
        this.betaMemory.commit();
    }

    public void clearMemories() {
        this.betaMemory.clear();
    }

    public String toString() {
        return "{evaluator=" + String.valueOf(this.evaluator) + ", sourceNodes=" + Arrays.stream((ReteSessionNode[])this.sourceNodes).map(Object::toString).collect(Collectors.joining(", ")) + "}";
    }

    static class FieldValuesMeta {
        private final FactFieldValues values;
        private final long valuesId;
        private final MemoryScope scope;

        public FieldValuesMeta(FactFieldValues values, long valuesId, MemoryScope scope) {
            this.values = values;
            this.valuesId = valuesId;
            this.scope = scope;
        }

        public String toString() {
            return "{" + String.valueOf((Object)this.scope) + ", " + this.valuesId + "=" + String.valueOf(this.values) + "}";
        }
    }

    private class ResolvedEvaluator {
        private final ResolvedEvaluatorComponent[] components;

        ResolvedEvaluator(AbstractRuleSessionBase<?> session, ReteKnowledgeEvaluator evaluator) {
            ReteKnowledgeEvaluator.Component[] componentDescriptors = evaluator.getComponents();
            this.components = new ResolvedEvaluatorComponent[componentDescriptors.length];
            for (int i = 0; i < componentDescriptors.length; ++i) {
                this.components[i] = new ResolvedEvaluatorComponent(session, componentDescriptors[i]);
            }
        }

        void refreshConditions() {
            for (ResolvedEvaluatorComponent component : this.components) {
                component.refreshCondition();
            }
        }

        boolean test() {
            for (ResolvedEvaluatorComponent component : this.components) {
                if (component.test()) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return Arrays.toString(this.components);
        }
    }

    private static class ListeningCombinationIterator
    extends CombinationIterator<ConditionMemory.MemoryEntry> {
        private final ObjIntConsumer<ConditionMemory.MemoryEntry> listener;

        public ListeningCombinationIterator(ConditionMemory.MemoryEntry[] sharedResultArray, IntFunction<Iterator<ConditionMemory.MemoryEntry>> iteratorFunction, ObjIntConsumer<ConditionMemory.MemoryEntry> listener) {
            super(sharedResultArray, iteratorFunction);
            this.listener = listener;
        }

        @Override
        protected ConditionMemory.MemoryEntry advanceIterator(int sourceIndex) {
            ConditionMemory.MemoryEntry entry = (ConditionMemory.MemoryEntry)super.advanceIterator(sourceIndex);
            this.listener.accept(entry, sourceIndex);
            return entry;
        }
    }

    class ResolvedEvaluatorComponent {
        final IntToValue values;
        StoredCondition condition;
        final AbstractRuleSessionBase<?> session;
        final DefaultEvaluatorHandle evaluatorHandle;

        ResolvedEvaluatorComponent(AbstractRuleSessionBase<?> session, ReteKnowledgeEvaluator.Component component) {
            this.session = session;
            this.evaluatorHandle = (DefaultEvaluatorHandle)component.getDelegate().getCondition();
            this.condition = this.refreshCondition();
            ReteKnowledgeEvaluator.Coordinate[] coordinates = component.getCoordinates();
            this.values = argIndex -> {
                ReteKnowledgeEvaluator.Coordinate c = coordinates[argIndex];
                int inNodeIdx = c.inNodeIdx;
                int valueIndex = c.fieldIdx;
                FactFieldValues fieldValues = ReteSessionConditionNode.this.currentFieldValues[inNodeIdx].values;
                return fieldValues.valueAt(valueIndex);
            };
        }

        StoredCondition refreshCondition() {
            this.condition = ReteSessionConditionNode.this.getActiveEvaluator(this.evaluatorHandle);
            return this.condition;
        }

        boolean test() {
            return this.condition.test(this.session, this.values);
        }

        public String toString() {
            return this.condition.toString();
        }
    }
}

