/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.stream.Stream;
import org.evrete.api.spi.GroupingReteMemory;
import org.evrete.api.spi.MemoryScope;

public class DefaultGroupingReteMemory<V>
implements GroupingReteMemory<V> {
    private MemoryImpl<V> main = new MemoryImpl();
    private MemoryImpl<V> delta = new MemoryImpl();

    MemoryImpl<V> getMain() {
        return this.main;
    }

    MemoryImpl<V> getDelta() {
        return this.delta;
    }

    @Override
    public void insert(long key, V value) {
        V v = Objects.requireNonNull(value);
        this.delta.insert(key, v);
    }

    @Override
    public void delete(long key, V value) {
        this.main.delete(key, value);
        this.delta.delete(key, value);
    }

    @Override
    public void commit() {
        if (!this.delta.isEmpty()) {
            this.main = this.main.copy();
            this.delta.forEach((key, value) -> this.main.computeIfAbsent(key, o -> new ValueCollection()).addAll(value));
            this.delta = new MemoryImpl();
        }
    }

    @Override
    public Iterator<Long> iterator(MemoryScope scope) {
        switch (scope) {
            case MAIN: {
                return this.main.keySet().iterator();
            }
            case DELTA: {
                return this.delta.keySet().iterator();
            }
        }
        throw new IllegalStateException("Unknown scope " + String.valueOf((Object)scope));
    }

    @Override
    public Iterator<V> valueIterator(MemoryScope scope, long key) {
        switch (scope) {
            case MAIN: {
                return this.main.values(key);
            }
            case DELTA: {
                return this.delta.values(key);
            }
        }
        throw new IllegalStateException("Unknown scope " + String.valueOf((Object)scope));
    }

    @Override
    public Stream<Long> stream(MemoryScope scope) {
        switch (scope) {
            case MAIN: {
                return this.main.keySet().stream();
            }
            case DELTA: {
                return this.delta.keySet().stream();
            }
        }
        throw new IllegalStateException("Unknown scope " + String.valueOf((Object)scope));
    }

    @Override
    public Stream<V> stream(MemoryScope scope, long key) {
        switch (scope) {
            case MAIN: {
                return this.main.stream(key);
            }
            case DELTA: {
                return this.delta.stream(key);
            }
        }
        throw new IllegalStateException("Unknown scope " + String.valueOf((Object)scope));
    }

    @Override
    public void clear() {
        this.main.clear();
        this.delta.clear();
    }

    public String toString() {
        return "{main=" + this.main.size() + ", delta=" + this.delta.size() + "}";
    }

    static class MemoryImpl<V>
    extends HashMap<Long, ValueCollection<V>> {
        MemoryImpl() {
        }

        private MemoryImpl(MemoryImpl<V> m) {
            super(m);
        }

        synchronized void insert(long key, V value) {
            this.computeIfAbsent(key, k -> new ValueCollection()).add(value);
        }

        synchronized void delete(long key, V value) {
            ValueCollection v = (ValueCollection)this.get(key);
            if (v != null) {
                v.remove(value);
                if (v.isEmpty()) {
                    this.remove(key);
                }
            }
        }

        synchronized MemoryImpl<V> copy() {
            return new MemoryImpl<V>(this);
        }

        Iterator<V> values(Object key) {
            ValueCollection collection = (ValueCollection)this.get(key);
            if (collection == null || collection.isEmpty()) {
                return Collections.emptyIterator();
            }
            return collection.iterator();
        }

        Stream<V> stream(Object key) {
            ValueCollection collection = (ValueCollection)this.get(key);
            if (collection == null || collection.isEmpty()) {
                return Stream.empty();
            }
            return collection.stream();
        }
    }

    static class ValueCollection<V> {
        private final LinkedHashSet<V> delegate;

        ValueCollection(LinkedHashSet<V> delegate) {
            this.delegate = delegate;
        }

        void addAll(ValueCollection<V> other) {
            if (other != null) {
                this.delegate.addAll(other.delegate);
            }
        }

        void remove(V value) {
            this.delegate.remove(value);
        }

        public Stream<V> stream() {
            return this.delegate.stream();
        }

        public Iterator<V> iterator() {
            return this.delegate.iterator();
        }

        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        void add(V value) {
            this.delegate.add(value);
        }

        ValueCollection() {
            this(new LinkedHashSet());
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

