/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.evrete.api.spi.ValueIndexer;
import org.evrete.collections.LongKeyMap;

public class DefaultValueIndexer<T>
implements ValueIndexer<T> {
    private final ConcurrentHashMap<T, Long> valueToLong = new ConcurrentHashMap();
    private final LongKeyMap<T> longToValue = new LongKeyMap();
    private final AtomicLong counter = new AtomicLong();

    @Override
    public long getOrCreateId(T value) {
        return this.valueToLong.computeIfAbsent(value, k -> {
            long id = this.counter.getAndIncrement();
            if (this.longToValue.put(id, value) == null) {
                return id;
            }
            throw new IllegalStateException("Value already exists: " + String.valueOf(value) + " : " + String.valueOf(this.valueToLong) + " : " + String.valueOf(this.longToValue));
        });
    }

    @Override
    public T get(long id) {
        return this.longToValue.get(id);
    }

    @Override
    public synchronized T delete(long id) {
        T found = this.longToValue.remove(id);
        if (found != null) {
            this.valueToLong.remove(found, id);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assignId(long id, T value) {
        DefaultValueIndexer defaultValueIndexer = this;
        synchronized (defaultValueIndexer) {
            this.longToValue.put(id, value);
            this.valueToLong.put(value, id);
            this.counter.updateAndGet(operand -> Math.max(operand, id + 1L));
        }
    }

    @Override
    public void clear() {
        this.longToValue.clear();
        this.valueToLong.clear();
        this.counter.set(0L);
    }

    ConcurrentHashMap<T, Long> getValueToLong() {
        return this.valueToLong;
    }

    LongKeyMap<T> getLongToValue() {
        return this.longToValue;
    }

    AtomicLong getCounter() {
        return this.counter;
    }
}

