/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.evrete.api.Type;
import org.evrete.api.TypeField;
import org.evrete.spi.minimal.Const;
import org.evrete.spi.minimal.TypeFieldImpl;

class TypeImpl<T>
implements Type<T> {
    private static final ValueReader[] EMPTY_VALUE_READERS = new ValueReader[0];
    private final String name;
    private final Map<String, TypeFieldImpl> fieldMap = new HashMap<String, TypeFieldImpl>();
    private final Class<T> javaType;

    TypeImpl(String name, Class<T> javaType) {
        Objects.requireNonNull(name);
        this.name = name;
        this.javaType = javaType;
    }

    private TypeImpl(TypeImpl<T> other) {
        this.fieldMap.putAll(other.fieldMap);
        this.name = other.name;
        this.javaType = other.javaType;
    }

    private static ValueReader resolve(MethodHandles.Lookup lookup, Class<?> clazz, String prop) {
        MethodHandle handle = null;
        for (Field field : clazz.getFields()) {
            if (!field.getName().equals(prop) || Modifier.isStatic(field.getModifiers())) continue;
            try {
                handle = lookup.unreflectGetter(field);
                break;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (handle != null) {
            return new ValueReader(handle);
        }
        for (MethodMeta methodMeta : MethodMeta.values()) {
            String methodName = methodMeta.buildName(prop);
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equals(methodName) || !methodMeta.validMethod(method)) continue;
                try {
                    handle = lookup.unreflect(method);
                    break;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            if (handle == null) continue;
            return new ValueReader(handle);
        }
        return null;
    }

    private static String capitalizeFirst(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    @Override
    public TypeImpl<T> copyOf() {
        return new TypeImpl<T>(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeImpl type = (TypeImpl)o;
        return this.name.equals(type.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeField getField(String name) {
        TypeField field = this.fieldMap.get(name);
        if (field == null) {
            TypeImpl typeImpl = this;
            synchronized (typeImpl) {
                field = this.fieldMap.get(name);
                if (field == null) {
                    field = this.resolveField(name);
                }
            }
        }
        if (field == null) {
            throw new IllegalArgumentException("Field not declared: '" + name + "'");
        }
        return field;
    }

    @Override
    public Class<T> getJavaClass() {
        return this.javaType;
    }

    @Override
    public <V> TypeField declareField(String name, Class<V> type, Function<T, V> function) {
        return this.innerDeclare(name, type, new Func<T, V>(function));
    }

    @Override
    @Deprecated
    public final String getJavaType() {
        return this.javaType.getName();
    }

    @Override
    @Deprecated
    public Class<T> resolveJavaType() {
        return this.javaType;
    }

    public String toString() {
        return "{name='" + this.name + "', fieldMap=" + String.valueOf(this.fieldMap) + ", javaType=" + String.valueOf(this.javaType) + ", zzz=" + System.identityHashCode(this) + "}";
    }

    private synchronized TypeField innerDeclare(String name, Class<?> type, Function<Object, ?> function) {
        Const.assertName(name);
        TypeFieldImpl field = new TypeFieldImpl(name, this, type, function);
        this.fieldMap.put(name, field);
        return field;
    }

    private TypeField resolveField(String fieldName) {
        Function<Object, Object> func;
        Class<Object> valueType;
        if (fieldName == null || fieldName.isEmpty()) {
            valueType = this.javaType;
            func = o -> o;
        } else {
            String[] parts = fieldName.split("\\.");
            ArrayList<ValueReader> getters = new ArrayList<ValueReader>();
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            valueType = this.javaType;
            for (String part : parts) {
                Const.assertName(part);
                ValueReader reader = TypeImpl.resolve(lookup, valueType, part);
                if (reader == null) {
                    return null;
                }
                valueType = reader.valueType();
                getters.add(reader);
            }
            func = getters.size() == 1 ? new AtomicFunction((ValueReader)getters.get(0)) : new NestedFunction(getters.toArray(EMPTY_VALUE_READERS));
        }
        return this.innerDeclare(fieldName, valueType, func);
    }

    private static final class ValueReader {
        private final MethodHandle handle;

        ValueReader(MethodHandle handle) {
            this.handle = handle;
        }

        Object read(Object o) throws Throwable {
            return this.handle.invoke(o);
        }

        Class<?> valueType() {
            return this.handle.type().returnType();
        }
    }

    private static enum MethodMeta {
        DEFAULT("get", true, false),
        BOOL("is", true, true),
        RAW("", false, false);

        private final String prefix;
        private final boolean capitalizeFirst;
        private final boolean requireBoolean;

        private MethodMeta(String prefix, boolean capitalizeFirst, boolean requireBoolean) {
            this.prefix = prefix;
            this.capitalizeFirst = capitalizeFirst;
            this.requireBoolean = requireBoolean;
        }

        String buildName(String prop) {
            if (this.capitalizeFirst) {
                return this.prefix + TypeImpl.capitalizeFirst(prop);
            }
            return this.prefix + prop;
        }

        boolean validMethod(Method method) {
            if (Modifier.isStatic(method.getModifiers())) {
                return false;
            }
            if (method.getParameterCount() > 0) {
                return false;
            }
            Class<?> retType = method.getReturnType();
            if (this.requireBoolean) {
                return retType.equals(Boolean.TYPE) || retType.equals(Boolean.class);
            }
            return !retType.equals(Void.TYPE);
        }
    }

    private static class Func<T, V>
    implements Function<Object, Object> {
        private final Function<T, V> delegate;

        private Func(Function<T, V> function) {
            this.delegate = function;
        }

        @Override
        public Object apply(Object o) {
            return this.delegate.apply(o);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private static class AtomicFunction
    implements Function<Object, Object> {
        private final ValueReader reader;

        AtomicFunction(ValueReader reader) {
            this.reader = reader;
        }

        @Override
        public Object apply(Object o) {
            try {
                return this.reader.read(o);
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        }
    }

    private static class NestedFunction
    implements Function<Object, Object> {
        private final ValueReader[] readers;

        NestedFunction(ValueReader[] readers) {
            this.readers = readers;
        }

        @Override
        public Object apply(Object o) {
            try {
                Object current = o;
                for (ValueReader reader : this.readers) {
                    if ((current = reader.read(current)) != null) continue;
                    return null;
                }
                return current;
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        }
    }
}

