/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.evrete.Configuration;
import org.evrete.api.Environment;

public class AbstractEnvironment
implements Environment {
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public AbstractEnvironment(AbstractEnvironment other) {
        this.properties.putAll(other.properties);
    }

    public AbstractEnvironment(Configuration configuration) {
        for (String key : configuration.stringPropertyNames()) {
            Object value = configuration.get(key);
            if (value == null) continue;
            this.properties.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object set(String property, Object value) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            this.properties.put(property, value);
            return this;
        }
    }

    @Override
    public final <T> T get(String property) {
        return (T)this.properties.get(property);
    }

    @Override
    public final Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }
}

