/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.Function;
import org.evrete.dsl.MalformedResourceException;

class ClassMethod {
    final boolean staticMethod;
    final Object[] args;
    private final MethodHandle handle;

    ClassMethod(MethodHandles.Lookup lookup, Method method) {
        this.staticMethod = Modifier.isStatic(method.getModifiers());
        try {
            this.handle = lookup.in(method.getDeclaringClass()).unreflect(method);
            this.args = new Object[this.handle.type().parameterCount()];
        }
        catch (IllegalAccessException e) {
            throw new MalformedResourceException("Rule method access exception", e);
        }
    }

    private ClassMethod(boolean staticMethod, MethodHandle handle) {
        this.staticMethod = staticMethod;
        this.handle = handle;
        this.args = new Object[handle.type().parameterCount()];
    }

    ClassMethod(ClassMethod method, Object instance) {
        this.staticMethod = method.staticMethod;
        this.handle = this.staticMethod ? method.handle : method.handle.bindTo(instance);
        this.args = new Object[this.handle.type().parameterCount()];
    }

    ClassMethod(ClassMethod other) {
        this.staticMethod = other.staticMethod;
        this.handle = other.handle;
        this.args = (Object[])other.args.clone();
    }

    static ClassMethod lookup(MethodHandles.Lookup lookup, Class<?> declaringClass, String name, MethodType methodType) {
        boolean staticMethod;
        MethodHandle handle;
        MethodHandles.Lookup declaringClassLookup = lookup.in(declaringClass);
        try {
            handle = declaringClassLookup.findStatic(declaringClass, name, methodType);
            staticMethod = true;
        }
        catch (IllegalAccessException | NoSuchMethodException e1) {
            try {
                handle = declaringClassLookup.findVirtual(declaringClass, name, methodType);
                staticMethod = false;
            }
            catch (IllegalAccessException | NoSuchMethodException e2) {
                throw new MalformedResourceException("Unable to find/access method '" + name + "' in " + declaringClass + " of type " + methodType);
            }
        }
        return new ClassMethod(staticMethod, handle);
    }

    final <T> T call() {
        try {
            return (T)this.handle.invokeWithArguments(this.args);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    final <V, R> Function<V, R> asFunction() {
        return new Function<V, R>(){

            @Override
            public R apply(V v) {
                ClassMethod.this.args[0] = v;
                return ClassMethod.this.call();
            }

            public String toString() {
                return ClassMethod.this.handle.toString();
            }
        };
    }
}

