/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import org.evrete.dsl.WrappedClass;

class WrappedMethod {
    private final MethodHandle handle;
    final boolean isStatic;
    final Object[] args;
    private final String methodName;
    final WrappedClass declaringClass;

    WrappedMethod(WrappedClass declaringClass, MethodHandle handle, String methodName, boolean isStatic) {
        this.declaringClass = declaringClass;
        this.handle = handle;
        this.isStatic = isStatic;
        this.methodName = methodName;
        int paramCount = handle.type().parameterCount();
        this.args = new Object[paramCount];
    }

    WrappedMethod(WrappedClass declaringClass, Method delegate) {
        this(declaringClass, declaringClass.getHandle(delegate), delegate.getName(), Modifier.isStatic(delegate.getModifiers()));
    }

    WrappedMethod(WrappedMethod other, Object bindInstance) {
        this(other.declaringClass, other.handle.bindTo(bindInstance), other.methodName, other.isStatic);
    }

    WrappedMethod(WrappedMethod other) {
        this(other.declaringClass, other.handle, other.methodName, other.isStatic);
    }

    final <V, R> Function<V, R> asFunction() {
        return new Func();
    }

    final <R> Consumer<R> asVoidFunction() {
        return new Cons();
    }

    final <T> T call() {
        try {
            return (T)this.handle.invokeWithArguments(this.args);
        }
        catch (Throwable t) {
            Object[] argTypes = new String[this.args.length];
            for (int i = 0; i < argTypes.length; ++i) {
                Object arg = this.args[i];
                argTypes[i] = arg == null ? null : arg.getClass().getName();
            }
            throw new RuntimeException("Method invocation exception at " + this + ", arguments: " + Arrays.toString(this.args) + " with types: " + Arrays.toString(argTypes), t);
        }
    }

    public String toString() {
        return "{name=" + this.methodName + ", handle=" + this.handle + ", static=" + this.isStatic + ", class='" + this.declaringClass.delegate.getName() + "'}'";
    }

    private class Func<V, R>
    implements Function<V, R> {
        private Func() {
        }

        @Override
        public R apply(V v) {
            WrappedMethod.this.args[0] = v;
            return (R)WrappedMethod.this.call();
        }

        public String toString() {
            return "Func{" + WrappedMethod.this.handle + "}";
        }
    }

    private class Cons<R>
    implements Consumer<R> {
        private Cons() {
        }

        @Override
        public void accept(R r) {
            WrappedMethod.this.args[0] = r;
            WrappedMethod.this.call();
        }

        public String toString() {
            return "Cons{" + WrappedMethod.this.handle + "}";
        }
    }
}

