/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.evrete.api.RuntimeContext;
import org.evrete.dsl.AbstractDSLProvider;
import org.evrete.dsl.JarClassloader;
import org.evrete.dsl.MalformedResourceException;
import org.evrete.dsl.ResourceClasses;
import org.evrete.dsl.Utils;
import org.evrete.dsl.annotation.RuleSet;
import org.evrete.util.CommonUtils;

public class DSLJarProvider
extends AbstractDSLProvider {
    private static final Logger LOGGER = Logger.getLogger(DSLJarProvider.class.getName());
    static final String CLASSES_PROPERTY = "org.evrete.dsl.rule-classes";
    static final String RULESETS_PROPERTY = "org.evrete.dsl.ruleset-names";
    private static final String EMPTY_STRING = "";
    private static final Class<?>[] SUPPORTED_TYPES = new Class[]{TYPE_URL, TYPE_FILE};

    @Override
    <C extends RuntimeContext<C>> ResourceClasses createFromFiles(RuntimeContext<C> context, Collection<File> resources) throws IOException {
        return this.createFromURLs(context, DSLJarProvider.toURLs(resources));
    }

    @Override
    <C extends RuntimeContext<C>> ResourceClasses createFromURLs(RuntimeContext<C> context, Collection<URL> resources) throws IOException {
        Collection<Class<?>> selectedRuleClasses;
        String[] criteria;
        JarClassloader jarClassloader = new JarClassloader(resources, context.getClassLoader());
        String[] configClasses = CommonUtils.splitConfigString((String)((String)context.get(CLASSES_PROPERTY, (Object)EMPTY_STRING)));
        if (configClasses.length == 0) {
            String[] configRuleSets = CommonUtils.splitCSV((String)((String)context.get(RULESETS_PROPERTY, (Object)EMPTY_STRING)));
            if (configRuleSets.length == 0) {
                throw new IllegalArgumentException("Neither ruleset names nor class names are specified");
            }
            criteria = configRuleSets;
            selectedRuleClasses = this.readRulesets(jarClassloader, configRuleSets);
        } else {
            criteria = configClasses;
            selectedRuleClasses = this.readClasses(jarClassloader, configClasses);
        }
        ArrayList dslClasses = new ArrayList(selectedRuleClasses.size());
        for (Class<?> ruleClass : selectedRuleClasses) {
            if (!Utils.isDslRuleClass(ruleClass)) continue;
            dslClasses.add(ruleClass);
        }
        if (dslClasses.isEmpty()) {
            LOGGER.fine(() -> "No rule classes selected given the provided criteria: " + Arrays.toString(criteria));
            return null;
        }
        return new ResourceClasses(jarClassloader, dslClasses, jarClassloader);
    }

    private Collection<Class<?>> readClasses(JarClassloader jarClassloader, String[] classNames) {
        ArrayList result = new ArrayList(classNames.length);
        for (String className : classNames) {
            try {
                result.add(jarClassloader.loadClass(className));
            }
            catch (ClassNotFoundException e) {
                throw new MalformedResourceException("Unable to load class " + className, e);
            }
        }
        return result;
    }

    private Collection<Class<?>> readRulesets(JarClassloader jarClassloader, String[] rulesetNames) throws IOException {
        HashMap stringClassMap = new HashMap();
        HashSet<String> filter = new HashSet<String>(Arrays.asList(rulesetNames));
        jarClassloader.scan(c -> {
            String ruleSetName;
            RuleSet rs = c.getAnnotation(RuleSet.class);
            if (rs != null && (ruleSetName = rs.value()) != null && !ruleSetName.isEmpty() && filter.contains(ruleSetName)) {
                stringClassMap.put(ruleSetName, c);
            }
        });
        ArrayList result = new ArrayList(stringClassMap.size());
        for (String ruleSetName : rulesetNames) {
            Class ruleClass = (Class)stringClassMap.get(ruleSetName);
            if (ruleClass == null) continue;
            result.add(ruleClass);
        }
        return result;
    }

    @Override
    public Set<Class<?>> sourceTypes() {
        return Set.of(SUPPORTED_TYPES);
    }

    public String getName() {
        return "JAVA-JAR";
    }
}

