/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.evrete.api.EvaluatorHandle;
import org.evrete.api.IntToValue;
import org.evrete.api.LhsField;
import org.evrete.api.NamedType;
import org.evrete.api.RhsContext;
import org.evrete.api.RuntimeContext;
import org.evrete.api.TypeField;
import org.evrete.api.ValuesPredicate;
import org.evrete.api.builders.LhsBuilder;
import org.evrete.api.builders.RuleBuilder;
import org.evrete.api.builders.RuleSetBuilder;
import org.evrete.dsl.MetadataCollector;
import org.evrete.dsl.RuleComparator;
import org.evrete.dsl.RuleMethod;
import org.evrete.dsl.Utils;
import org.evrete.dsl.WrappedClass;
import org.evrete.dsl.WrappedConditionMethod;
import org.evrete.dsl.WrappedEventSubscriptionMethod;
import org.evrete.dsl.WrappedFieldDeclarationMethod;
import org.evrete.dsl.WrappedMethod;
import org.evrete.dsl.annotation.EventSubscription;
import org.evrete.dsl.annotation.FieldDeclaration;
import org.evrete.dsl.annotation.MethodPredicate;
import org.evrete.dsl.annotation.Rule;
import org.evrete.dsl.annotation.RuleSet;

class RulesClass
extends WrappedClass {
    final List<RuleMethod> ruleMethods = new LinkedList<RuleMethod>();
    final List<WrappedFieldDeclarationMethod<?, ?>> fieldDeclarationMethods = new LinkedList();
    final List<WrappedEventSubscriptionMethod<?>> subscriptionMethods = new LinkedList();

    RulesClass(WrappedClass other) {
        super(other);
        for (Method m : this.publicMethods) {
            Rule ruleAnnotation = m.getAnnotation(Rule.class);
            FieldDeclaration fieldDeclaration = m.getAnnotation(FieldDeclaration.class);
            EventSubscription eventSubscription = m.getAnnotation(EventSubscription.class);
            if (ruleAnnotation != null) {
                this.ruleMethods.add(new RuleMethod(this, m, ruleAnnotation));
                continue;
            }
            if (fieldDeclaration != null) {
                this.fieldDeclarationMethods.add(new WrappedFieldDeclarationMethod(this, m, fieldDeclaration));
                continue;
            }
            if (eventSubscription == null) continue;
            this.subscriptionMethods.add(new WrappedEventSubscriptionMethod(this, m, eventSubscription.async()));
        }
        RuleSet.Sort defaultSort = Utils.deriveSort(this.delegate);
        this.ruleMethods.sort(new RuleComparator(defaultSort));
    }

    final void collectMetaData(RuntimeContext<?> context, MetadataCollector collector) {
        for (WrappedFieldDeclarationMethod<?, ?> wrappedFieldDeclarationMethod : this.fieldDeclarationMethods) {
            if (wrappedFieldDeclarationMethod.isStatic) {
                context.configureTypes(wrappedFieldDeclarationMethod::selfRegister);
                continue;
            }
            context.configureTypes(wrappedFieldDeclarationMethod::dummyRegister);
            collector.addFieldDeclarationMethod(wrappedFieldDeclarationMethod);
        }
        for (WrappedEventSubscriptionMethod wrappedEventSubscriptionMethod : this.subscriptionMethods) {
            if (wrappedEventSubscriptionMethod.isStatic) {
                wrappedEventSubscriptionMethod.selfSubscribe(context);
                continue;
            }
            collector.addEventSubscriptionMethod(wrappedEventSubscriptionMethod);
        }
    }

    void applyTo(RuleSetBuilder<?> target, MetadataCollector collector) {
        for (RuleMethod ruleMethod : this.ruleMethods) {
            RuleBuilder ruleBuilder = target.newRule(ruleMethod.getRuleName());
            ruleBuilder.set("evrete.impl.rule-base-class", (Object)this.delegate.getCanonicalName());
            int salience = ruleMethod.getSalience();
            if (salience != Integer.MIN_VALUE) {
                ruleBuilder.salience(salience);
            }
            LhsBuilder lhsBuilder = ruleBuilder.getLhs();
            for (RuleMethod.FactDeclaration factDeclaration : ruleMethod.rhs.factDeclarations) {
                Class<?> cl = Utils.box(factDeclaration.javaType);
                if (factDeclaration.logicalType == null) {
                    lhsBuilder.addFactDeclaration(factDeclaration.name, cl);
                    continue;
                }
                lhsBuilder.addFactDeclaration(factDeclaration.name, factDeclaration.logicalType);
            }
            lhsBuilder.where(ruleMethod.literalConditions);
            for (MethodPredicate mp : ruleMethod.methodPredicates) {
                String methodName = mp.method();
                LhsField.Array descriptor = LhsField.Array.toFields((String[])mp.args(), (NamedType.Resolver)ruleBuilder);
                Class<?>[] signature = Utils.asMethodSignature((LhsField.Array<String, TypeField>)descriptor);
                MethodType methodType = MethodType.methodType(Boolean.TYPE, signature);
                WrappedMethod conditionMethod = this.lookup(methodName, methodType);
                WrappedConditionMethod condition = new WrappedConditionMethod(conditionMethod);
                if (conditionMethod.isStatic) {
                    ruleBuilder.getConditionManager().addCondition((ValuesPredicate)condition, mp.args());
                    continue;
                }
                EvaluatorHandle handle = ruleBuilder.getConditionManager().addCondition((ValuesPredicate)new FailingPredicate(), mp.args());
                collector.scheduleConditionMethodUpdate(handle, condition);
            }
            if (ruleMethod.rhs.isStatic) {
                lhsBuilder.execute((Consumer)ruleMethod.rhs);
                continue;
            }
            lhsBuilder.execute((Consumer)new FailingRhs());
            collector.scheduleRhsMethodUpdate(ruleBuilder.getName(), ruleMethod.rhs);
        }
    }

    private static class FailingPredicate
    implements ValuesPredicate {
        private FailingPredicate() {
        }

        public boolean test(IntToValue t) {
            throw new UnsupportedOperationException("LHS condition not updated. Please report it as a bug.");
        }

        public String toString() {
            return "FailingPredicate{hash=" + System.identityHashCode(this) + '}';
        }
    }

    private static class FailingRhs
    implements Consumer<RhsContext> {
        private FailingRhs() {
        }

        @Override
        public void accept(RhsContext rhsContext) {
            throw new UnsupportedOperationException("RHS action not updated. Please report it as a bug.");
        }
    }
}

