/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.function.Function;
import org.evrete.api.Type;
import org.evrete.api.TypeResolver;
import org.evrete.dsl.AbstractDSLProvider;
import org.evrete.dsl.MalformedResourceException;
import org.evrete.dsl.WrappedClass;
import org.evrete.dsl.WrappedCloneableMethod;
import org.evrete.dsl.annotation.FieldDeclaration;

class WrappedFieldDeclarationMethod<T, V>
extends WrappedCloneableMethod<WrappedFieldDeclarationMethod<T, V>> {
    final Class<T> factJavaType;
    private final String factLogicalName;
    final String fieldName;
    private final Class<V> fieldType;

    public WrappedFieldDeclarationMethod(WrappedClass declaringClass, Method delegate, FieldDeclaration ann) {
        super(declaringClass, delegate);
        String declaredName = ann.name().trim();
        this.fieldName = declaredName.isEmpty() ? delegate.getName() : declaredName;
        this.fieldType = delegate.getReturnType();
        if (this.fieldType.equals(Void.TYPE) || this.fieldType.equals(Void.class)) {
            throw new MalformedResourceException("Method " + delegate + " in the " + delegate.getDeclaringClass() + " is annotated as field declaration but is void");
        }
        Parameter[] parameters = delegate.getParameters();
        if (parameters.length != 1) {
            throw new IllegalArgumentException("FieldDeclaration method must have exactly one parameter. Failed method: " + delegate);
        }
        String typeName = ann.type();
        this.factJavaType = parameters[0].getType();
        this.factLogicalName = typeName == null || typeName.isEmpty() ? Type.logicalNameOf(this.factJavaType) : typeName;
        AbstractDSLProvider.LOGGER.fine(() -> "New field declaration. Subject: '" + this.factLogicalName + "' (" + this.factJavaType.getName() + "), Field: '" + this.fieldName + "' (" + this.fieldType.getName() + "), Declaring method: " + delegate);
    }

    WrappedFieldDeclarationMethod(WrappedFieldDeclarationMethod<T, V> other, Object bindInstance) {
        super(other, bindInstance);
        this.factLogicalName = other.factLogicalName;
        this.factJavaType = other.factJavaType;
        this.fieldName = other.fieldName;
        this.fieldType = other.fieldType;
    }

    void selfRegister(TypeResolver resolver) {
        this.selfRegister(resolver, this.asFunction());
    }

    private void selfRegister(TypeResolver resolver, Function<T, V> fieldFunction) {
        resolver.getOrDeclare(this.factLogicalName, this.factJavaType).declareField(this.fieldName, this.fieldType, fieldFunction);
    }

    void dummyRegister(TypeResolver resolver) {
        this.selfRegister(resolver, new FailingFunction());
    }

    @Override
    WrappedFieldDeclarationMethod<T, V> bindTo(Object bindInstance) {
        return new WrappedFieldDeclarationMethod<T, V>(this, bindInstance);
    }

    static class FailingFunction<T, V>
    implements Function<T, V> {
        FailingFunction() {
        }

        @Override
        public V apply(T t) {
            throw new IllegalStateException("Field declaration not updated, please report the bug.");
        }
    }
}

