/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.evrete.api.RuntimeContext;
import org.evrete.api.events.ContextEvent;
import org.evrete.api.events.Events;
import org.evrete.dsl.MalformedResourceException;
import org.evrete.dsl.WrappedClass;
import org.evrete.dsl.WrappedCloneableMethod;

class WrappedEventSubscriptionMethod<E extends ContextEvent>
extends WrappedCloneableMethod<WrappedEventSubscriptionMethod<E>> {
    private final Class<E> eventClass;
    private final boolean async;

    public WrappedEventSubscriptionMethod(WrappedClass declaringClass, Method delegate, boolean async) {
        super(declaringClass, delegate);
        this.async = async;
        if (!delegate.getReturnType().equals(Void.TYPE)) {
            throw new MalformedResourceException("Event subscription methods must be void: " + delegate);
        }
        Parameter[] parameters = delegate.getParameters();
        if (parameters.length != 1) {
            throw new MalformedResourceException("Event subscription methods must have exactly one argument: " + delegate);
        }
        Parameter parameter = parameters[0];
        Class<?> parameterType = parameter.getType();
        if (!ContextEvent.class.isAssignableFrom(parameterType)) {
            throw new MalformedResourceException("Invalid event subscription method argument: " + parameter);
        }
        this.eventClass = parameterType;
    }

    public WrappedEventSubscriptionMethod(WrappedEventSubscriptionMethod<E> other, Object bindInstance) {
        super(other, bindInstance);
        this.eventClass = other.eventClass;
        this.async = other.async;
    }

    void selfSubscribe(RuntimeContext<?> context) {
        Events.Subscription subscription = context.subscribe(this.eventClass, this.async, this.asVoidFunction());
        context.getService().getServiceSubscriptions().add(subscription);
    }

    @Override
    WrappedEventSubscriptionMethod<E> bindTo(Object bindInstance) {
        return new WrappedEventSubscriptionMethod<E>(this, bindInstance);
    }
}

