/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Logger;
import org.evrete.Configuration;
import org.evrete.api.RuleSession;
import org.evrete.api.RuntimeContext;
import org.evrete.api.builders.RuleSetBuilder;
import org.evrete.api.events.Events;
import org.evrete.api.events.SessionCreatedEvent;
import org.evrete.api.spi.DSLKnowledgeProvider;
import org.evrete.dsl.Constants;
import org.evrete.dsl.MetadataCollector;
import org.evrete.dsl.ResourceClasses;
import org.evrete.dsl.ResourceCollection;
import org.evrete.dsl.RulesClass;
import org.evrete.dsl.WrappedClass;

abstract class AbstractDSLProvider
implements DSLKnowledgeProvider,
Constants {
    static final Logger LOGGER = Logger.getLogger(AbstractDSLProvider.class.getName());
    static final Class<?> TYPE_URL = URL.class;
    static final Class<?> TYPE_CHAR_SEQUENCE = CharSequence.class;
    static final Class<?> TYPE_READER = Reader.class;
    static final Class<?> TYPE_INPUT_STREAM = InputStream.class;
    static final Class<?> TYPE_CLASS = Class.class;
    static final Class<?> TYPE_FILE = File.class;
    final MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();

    AbstractDSLProvider() {
    }

    <C extends RuntimeContext<C>> ResourceClasses createFromURLs(RuntimeContext<C> target, Collection<URL> resources) throws IOException {
        throw new UnsupportedOperationException();
    }

    <C extends RuntimeContext<C>> ResourceClasses createFromReaders(RuntimeContext<C> target, Collection<Reader> resources) throws IOException {
        throw new UnsupportedOperationException();
    }

    <C extends RuntimeContext<C>> ResourceClasses createFromStrings(RuntimeContext<C> target, Collection<CharSequence> resources) {
        throw new UnsupportedOperationException();
    }

    <C extends RuntimeContext<C>> ResourceClasses createFromStreams(RuntimeContext<C> target, Collection<InputStream> resources) throws IOException {
        throw new UnsupportedOperationException();
    }

    <C extends RuntimeContext<C>> ResourceClasses createFromClasses(RuntimeContext<C> target, Collection<Class<?>> resources) {
        throw new UnsupportedOperationException();
    }

    <C extends RuntimeContext<C>> ResourceClasses createFromFiles(RuntimeContext<C> target, Collection<File> resources) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected abstract Set<Class<?>> sourceTypes();

    public final <C extends RuntimeContext<C>> void appendTo(RuntimeContext<C> context, Object source) throws IOException {
        if (source != null) {
            try {
                this.appendToInner(context, source);
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        } else {
            LOGGER.warning(() -> "No sources specified");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <C extends RuntimeContext<C>> void appendToInner(RuntimeContext<C> context, Object source) throws IOException {
        Set<Class<?>> supportedTypes = this.sourceTypes();
        ResourceCollection resources = ResourceCollection.factory(source);
        if (resources == null) {
            return;
        }
        Class<?> componentType = resources.getComponentType();
        if (!AbstractDSLProvider.matches(componentType, supportedTypes)) throw new IllegalArgumentException("Unsupported source type " + componentType.getName() + " provided to " + this.getClass().getName());
        if (TYPE_URL.isAssignableFrom(componentType)) {
            this.appendToInner(context, this.createFromURLs(context, resources.cast()));
            return;
        } else if (TYPE_READER.isAssignableFrom(componentType)) {
            this.appendToInner(context, this.createFromReaders(context, resources.cast()));
            return;
        } else if (TYPE_CHAR_SEQUENCE.isAssignableFrom(componentType)) {
            this.appendToInner(context, this.createFromStrings(context, resources.cast()));
            return;
        } else if (TYPE_INPUT_STREAM.isAssignableFrom(componentType)) {
            this.appendToInner(context, this.createFromStreams(context, resources.cast()));
            return;
        } else if (TYPE_CLASS.isAssignableFrom(componentType)) {
            this.appendToInner(context, this.createFromClasses(context, resources.cast()));
            return;
        } else {
            if (!TYPE_FILE.isAssignableFrom(componentType)) throw new IllegalArgumentException("Unsupported source type " + componentType);
            this.appendToInner(context, this.createFromFiles(context, resources.cast()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <C extends RuntimeContext<C>> void appendToInner(RuntimeContext<C> context, ResourceClasses resourceClasses) throws IOException {
        if (resourceClasses != null) {
            try {
                ArrayList<RulesClass> rulesClasses = new ArrayList<RulesClass>(resourceClasses.classes.size());
                for (Class<?> cl : resourceClasses.classes) {
                    WrappedClass wrappedClass = new WrappedClass(cl, this.publicLookup);
                    RulesClass rulesClass = new RulesClass(wrappedClass);
                    rulesClasses.add(rulesClass);
                }
                this.buildAndAppendRules(context, resourceClasses.classLoader, rulesClasses);
            }
            finally {
                resourceClasses.closeResources();
            }
        } else {
            LOGGER.warning("No resources were selected, no rules will be applied");
        }
    }

    private <C extends RuntimeContext<C>> void buildAndAppendRules(RuntimeContext<C> context, ClassLoader classLoader, Collection<RulesClass> rulesClasses) {
        MetadataCollector initMeta = new MetadataCollector();
        for (RulesClass rulesClass : rulesClasses) {
            rulesClass.collectMetaData(context, initMeta);
        }
        RuleSetBuilder target = context.builder(classLoader);
        for (RulesClass rulesClass : rulesClasses) {
            rulesClass.applyTo(target, initMeta);
        }
        target.build();
        if (!initMeta.classesToInstantiate.isEmpty()) {
            if (context instanceof RuleSession) {
                initMeta.applyToSession((RuleSession)context);
            } else {
                Events.Subscription subscription = context.subscribe(SessionCreatedEvent.class, event -> initMeta.applyToSession(event.getSession()));
                context.getService().getServiceSubscriptions().add(subscription);
            }
        }
    }

    static Charset charset(Configuration configuration) {
        String charSet = configuration.getProperty("org.evrete.dsl.sources-charset", "UTF-8");
        return Charset.forName(charSet);
    }

    static boolean matches(Class<?> clazz, Set<Class<?>> set) {
        for (Class<?> c : set) {
            if (!c.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    static Collection<URL> toURLs(Collection<File> files) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : files) {
            urls.add(file.toURI().toURL());
        }
        return urls;
    }
}

