/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.evrete.api.RuntimeContext;
import org.evrete.dsl.AbstractDSLProvider;
import org.evrete.dsl.ResourceClasses;

public class DSLClassProvider
extends AbstractDSLProvider {
    private static final Class<?>[] SUPPORTED_TYPES = new Class[]{TYPE_CLASS, TYPE_CHAR_SEQUENCE};

    @Override
    <C extends RuntimeContext<C>> ResourceClasses createFromClasses(RuntimeContext<C> context, Collection<Class<?>> resources) {
        if (resources == null || resources.isEmpty()) {
            return null;
        }
        return new ResourceClasses(context.getClassLoader(), resources);
    }

    @Override
    <C extends RuntimeContext<C>> ResourceClasses createFromStrings(RuntimeContext<C> context, Collection<CharSequence> resources) {
        ClassLoader classLoader = context.getClassLoader();
        try {
            ArrayList classResources = new ArrayList(resources.size());
            for (CharSequence resource : resources) {
                Class<?> cl = Class.forName(resource.toString(), true, classLoader);
                classResources.add(cl);
            }
            return this.createFromClasses(context, classResources);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find class " + resources, e);
        }
    }

    @Override
    protected Set<Class<?>> sourceTypes() {
        return new HashSet(Arrays.asList(SUPPORTED_TYPES));
    }

    public String getName() {
        return "JAVA-CLASS";
    }
}

