/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import org.evrete.dsl.MalformedResourceException;
import org.evrete.dsl.WrappedMethod;

class WrappedClass {
    protected final Class<?> delegate;
    protected final Method[] publicMethods;
    private final MethodHandles.Lookup classLookup;

    WrappedClass(Class<?> delegate, MethodHandles.Lookup publicLookup) {
        this.delegate = delegate;
        this.classLookup = publicLookup.in(delegate);
        this.publicMethods = delegate.getMethods();
    }

    protected WrappedClass(WrappedClass other) {
        this.delegate = other.delegate;
        this.publicMethods = other.publicMethods;
        this.classLookup = other.classLookup;
    }

    MethodHandle getHandle(Method m) {
        try {
            return this.classLookup.unreflect(m);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to access method " + m, e);
        }
    }

    WrappedMethod lookup(String name, MethodType methodType) {
        boolean staticMethod;
        MethodHandle handle;
        try {
            handle = this.classLookup.findStatic(this.delegate, name, methodType);
            staticMethod = true;
        }
        catch (IllegalAccessException | NoSuchMethodException e1) {
            try {
                handle = this.classLookup.findVirtual(this.delegate, name, methodType);
                staticMethod = false;
            }
            catch (IllegalAccessException | NoSuchMethodException e2) {
                throw new MalformedResourceException("Unable to find/access method '" + name + "' in " + this.delegate + " of type " + methodType);
            }
        }
        return new WrappedMethod(this, handle, name, staticMethod);
    }
}

