/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import org.evrete.api.FactBuilder;
import org.evrete.api.LhsBuilder;
import org.evrete.api.RuleBuilder;
import org.evrete.api.RuntimeContext;
import org.evrete.api.spi.DSLKnowledgeProvider;
import org.evrete.dsl.JavaClassRuleSet;
import org.evrete.dsl.LhsParameter;
import org.evrete.dsl.RuleMethod;
import org.evrete.dsl.annotation.MethodPredicate;
import org.evrete.dsl.annotation.Where;

abstract class AbstractJavaDSLProvider
implements DSLKnowledgeProvider {
    static final String PROVIDER_JAVA_S = "JAVA-SOURCE";
    static final String PROVIDER_JAVA_C = "JAVA-CLASS";
    static final String PROVIDER_JAVA_J = "JAVA-JAR";

    AbstractJavaDSLProvider() {
    }

    static void processRuleSet(RuntimeContext<?> targetContext, JavaClassRuleSet ruleSet) {
        for (RuleMethod rm : ruleSet.getRuleMethods()) {
            RuleBuilder builder = targetContext.newRule(rm.getName());
            builder.setSalience(rm.getSalience());
            LhsParameter[] factParameters = rm.getLhsParameters();
            FactBuilder[] facts = new FactBuilder[factParameters.length];
            for (int i = 0; i < factParameters.length; ++i) {
                LhsParameter lhsParameter = factParameters[i];
                facts[i] = FactBuilder.fact((String)lhsParameter.getLhsRef(), lhsParameter.getFactType());
            }
            LhsBuilder lhsBuilder = (LhsBuilder)builder.forEach(facts);
            Where predicates = rm.getPredicates();
            if (predicates != null) {
                for (String stringPredicate : predicates.value()) {
                    lhsBuilder = lhsBuilder.where(new String[]{stringPredicate});
                }
                for (MethodPredicate methodPredicate : predicates.asMethods()) {
                    lhsBuilder.where(ruleSet.resolve(lhsBuilder, rm, methodPredicate), methodPredicate.descriptor());
                }
            }
            lhsBuilder.execute((Consumer)rm);
        }
    }

    static String[] toSourceString(Reader[] readers) throws IOException {
        String[] sources = new String[readers.length];
        for (int i = 0; i < readers.length; ++i) {
            String line;
            Reader reader = readers[i];
            BufferedReader bufferedReader = new BufferedReader(reader);
            StringBuilder source = new StringBuilder(4096);
            while ((line = bufferedReader.readLine()) != null) {
                source.append(line).append("\n");
            }
            bufferedReader.close();
            sources[i] = source.toString();
        }
        return sources;
    }

    static String[] toSourceString(Charset charset, InputStream ... streams) throws IOException {
        String[] sources = new String[streams.length];
        for (int i = 0; i < sources.length; ++i) {
            sources[i] = new String(AbstractJavaDSLProvider.toByteArray(streams[i]), charset);
        }
        return sources;
    }

    public final void apply(RuntimeContext<?> targetContext, URL ... resources) throws IOException {
        if (resources == null || resources.length == 0) {
            return;
        }
        InputStream[] streams = new InputStream[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            streams[i] = resources[i].openStream();
        }
        this.apply(targetContext, streams);
        for (InputStream stream : streams) {
            stream.close();
        }
    }

    static byte[] toByteArray(InputStream is) throws IOException {
        int length;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) != -1) {
            bos.write(buffer, 0, length);
        }
        bos.close();
        return bos.toByteArray();
    }
}

