/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.evrete.api.ExpressionResolver;
import org.evrete.api.FieldReference;
import org.evrete.api.IntToValue;
import org.evrete.api.LhsBuilder;
import org.evrete.api.ValuesPredicate;
import org.evrete.dsl.DefaultSort;
import org.evrete.dsl.JavaDSLSourceProvider;
import org.evrete.dsl.MalformedResourceException;
import org.evrete.dsl.RuleComparator;
import org.evrete.dsl.RuleMethod;
import org.evrete.dsl.annotation.MethodPredicate;
import org.evrete.dsl.annotation.Rule;
import org.evrete.dsl.annotation.RuleSortPolicy;

class JavaClassRuleSet {
    private final List<RuleMethod> ruleMethods;
    private final Class<?> ruleSetClass;
    private final Object instance;

    JavaClassRuleSet(Class<?> clazz) {
        try {
            this.instance = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            throw new MalformedResourceException("Unable to create instance of " + clazz.getName() + ". Rule set must be a pubic class with zero-argument constructor.", t);
        }
        this.ruleSetClass = clazz;
        Method[] classMethods = clazz.getMethods();
        this.ruleMethods = new ArrayList<RuleMethod>(classMethods.length);
        for (Method m : classMethods) {
            Rule ann = m.getAnnotation(Rule.class);
            if (ann == null) continue;
            if (Modifier.isPublic(m.getModifiers())) {
                if (m.getReturnType().equals(Void.TYPE)) {
                    this.ruleMethods.add(new RuleMethod(m, ann, this.instance));
                    continue;
                }
                throw new MalformedResourceException("Non-void method '" + m.getName() + "' is annotated as @Rule.");
            }
            throw new MalformedResourceException("Non-public method annotated as @Rule: " + m.getName());
        }
        if (this.ruleMethods.isEmpty()) {
            JavaDSLSourceProvider.LOGGER.warning("No rule methods found in the source, ruleset is empty");
        } else {
            DefaultSort defaultSort = JavaClassRuleSet.deriveSort(clazz);
            defaultSort = defaultSort == null ? DefaultSort.DEFAULT : defaultSort;
            this.ruleMethods.sort(new RuleComparator(defaultSort));
        }
    }

    private static DefaultSort deriveSort(Class<?> clazz) {
        RuleSortPolicy policy = clazz.getAnnotation(RuleSortPolicy.class);
        if (policy != null) {
            return policy.value();
        }
        Class<?> parent = clazz.getSuperclass();
        if (parent.equals(Object.class)) {
            return null;
        }
        return JavaClassRuleSet.deriveSort(parent);
    }

    List<RuleMethod> getRuleMethods() {
        return this.ruleMethods;
    }

    ValuesPredicate resolve(LhsBuilder<?> lhs, RuleMethod rm, MethodPredicate predicate) {
        String[] descriptor = predicate.descriptor();
        if (descriptor.length == 0) {
            throw new MalformedResourceException("Condition method must have arguments (non-empty descriptor() annotation value)");
        }
        Class[] signature = new Class[descriptor.length];
        ExpressionResolver expressionResolver = lhs.getRuleBuilder().getRuntime().getExpressionResolver();
        for (int i = 0; i < descriptor.length; ++i) {
            FieldReference ref = expressionResolver.resolve(descriptor[i], lhs.getFactTypeMapper());
            signature[i] = ref.field().getValueType();
        }
        MethodType methodType = MethodType.methodType(Boolean.TYPE, signature);
        String methodName = predicate.method();
        boolean staticHandle = true;
        MethodHandle handle = this.resolveMethod(methodName, true, methodType);
        if (!rm.staticMethod && handle == null) {
            staticHandle = false;
            handle = this.resolveMethod(methodName, false, methodType);
        }
        if (handle == null) {
            throw new MalformedResourceException("Unable to find/access condition method '" + methodName + "' with signature " + methodType);
        }
        return staticHandle ? new MethodPredicateStatic(handle, signature.length) : new MethodPredicateNonStatic(handle, signature.length + 1, this.instance);
    }

    private MethodHandle resolveMethod(String method, boolean staticMethod, MethodType type) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup().in(this.ruleSetClass);
            return staticMethod ? lookup.findStatic(this.ruleSetClass, method, type) : lookup.findVirtual(this.ruleSetClass, method, type);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }

    private static class MethodPredicateStatic
    extends AbstractMethodPredicate {
        MethodPredicateStatic(MethodHandle handle, int size) {
            super(handle, size);
        }

        @Override
        void init(IntToValue values) {
            for (int i = 0; i < this.currentValues.length; ++i) {
                this.currentValues[i] = values.apply(i);
            }
        }
    }

    private static class MethodPredicateNonStatic
    extends AbstractMethodPredicate {
        MethodPredicateNonStatic(MethodHandle handle, int size, Object instance) {
            super(handle, size);
            this.currentValues[0] = instance;
        }

        @Override
        void init(IntToValue values) {
            for (int i = 1; i < this.currentValues.length; ++i) {
                this.currentValues[i] = values.apply(i - 1);
            }
        }
    }

    static abstract class AbstractMethodPredicate
    implements ValuesPredicate {
        final Object[] currentValues;
        final MethodHandle handle;

        AbstractMethodPredicate(MethodHandle handle, int size) {
            this.handle = handle;
            this.currentValues = new Object[size];
        }

        abstract void init(IntToValue var1);

        public final boolean test(IntToValue values) {
            try {
                this.init(values);
                return (Boolean)this.handle.invokeWithArguments(this.currentValues);
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }
}

