/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import org.evrete.KnowledgeService;
import org.evrete.api.Knowledge;
import org.evrete.api.RuleScope;
import org.evrete.api.RuntimeContext;
import org.evrete.dsl.AbstractJavaDSLProvider;
import org.evrete.dsl.JavaClassRuleSet;
import org.evrete.util.compiler.BytesClassLoader;

public class JavaDSLClassProvider
extends AbstractJavaDSLProvider {
    private static void apply(RuntimeContext<?> targetContext, byte[][] bytes) {
        ClassLoader ctxClassLoader = targetContext.getClassLoader();
        ProtectionDomain domain = targetContext.getService().getSecurity().getProtectionDomain(RuleScope.BOTH);
        BytesClassLoader loader = new BytesClassLoader(ctxClassLoader, domain);
        for (byte[] arr : bytes) {
            JavaDSLClassProvider.processRuleSet(targetContext, new JavaClassRuleSet(loader.buildClass(arr)));
        }
    }

    public String getName() {
        return "JAVA-CLASS";
    }

    public Knowledge create(KnowledgeService service, URL ... resources) throws IOException {
        Knowledge knowledge = service.newKnowledge();
        this.apply((RuntimeContext<?>)knowledge, resources);
        return knowledge;
    }

    public void apply(RuntimeContext<?> targetContext, InputStream ... streams) throws IOException {
        byte[][] bytes = new byte[streams.length][];
        for (int i = 0; i < streams.length; ++i) {
            bytes[i] = JavaDSLClassProvider.toByteArray(streams[i]);
        }
        JavaDSLClassProvider.apply(targetContext, bytes);
    }
}

